/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetFederationTokenRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetFederationTokenRequest.Builder, GetFederationTokenRequest> {
    private final String name;

    private final String policy;

    private final Integer durationSeconds;

    private GetFederationTokenRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * The name of the federated user. The name is used as an identifier for the temporary security credentials (such as
     * <code>Bob</code>). For example, you can reference the federated user name in a resource-based policy, such as in
     * an Amazon S3 bucket policy.
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     * </p>
     * 
     * @return The name of the federated user. The name is used as an identifier for the temporary security credentials
     *         (such as <code>Bob</code>). For example, you can reference the federated user name in a resource-based
     *         policy, such as in an Amazon S3 bucket policy.</p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@-
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An IAM policy in JSON format that is passed with the <code>GetFederationToken</code> call and evaluated along
     * with the policy or policies that are attached to the IAM user whose credentials are used to call
     * <code>GetFederationToken</code>. The passed policy is used to scope down the permissions that are available to
     * the IAM user, by allowing only a subset of the permissions that are granted to the IAM user. The passed policy
     * cannot grant more permissions than those granted to the IAM user. The final permissions for the federated user
     * are the most restrictive set based on the intersection of the passed policy and the IAM user policy.
     * </p>
     * <p>
     * If you do not pass a policy, the resulting temporary security credentials have no effective permissions. The only
     * exception is when the temporary security credentials are used to access a resource that has a resource-based
     * policy that specifically allows the federated user to access the resource.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048 characters
     * in length. The characters can be any ASCII character from the space character to the end of the valid character
     * list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a packed
     * binary format with a separate limit. The PackedPolicySize response element indicates by percentage how close to
     * the upper size limit the policy is, with 100% equaling the maximum allowed size.
     * </p>
     * </note>
     * <p>
     * For more information about how permissions work, see <a href=
     * "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html"
     * >Permissions for GetFederationToken</a>.
     * </p>
     * 
     * @return An IAM policy in JSON format that is passed with the <code>GetFederationToken</code> call and evaluated
     *         along with the policy or policies that are attached to the IAM user whose credentials are used to call
     *         <code>GetFederationToken</code>. The passed policy is used to scope down the permissions that are
     *         available to the IAM user, by allowing only a subset of the permissions that are granted to the IAM user.
     *         The passed policy cannot grant more permissions than those granted to the IAM user. The final permissions
     *         for the federated user are the most restrictive set based on the intersection of the passed policy and
     *         the IAM user policy.</p>
     *         <p>
     *         If you do not pass a policy, the resulting temporary security credentials have no effective permissions.
     *         The only exception is when the temporary security credentials are used to access a resource that has a
     *         resource-based policy that specifically allows the federated user to access the resource.
     *         </p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
     *         characters in length. The characters can be any ASCII character from the space character to the end of
     *         the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return (
     *         ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
     *         packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage
     *         how close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
     *         </p>
     *         </note>
     *         <p>
     *         For more information about how permissions work, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html"
     *         >Permissions for GetFederationToken</a>.
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The duration, in seconds, that the session should last. Acceptable durations for federation sessions range from
     * 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as the default. Sessions
     * obtained using AWS account (root) credentials are restricted to a maximum of 3600 seconds (one hour). If the
     * specified duration is longer than one hour, the session obtained by using AWS account (root) credentials defaults
     * to one hour.
     * </p>
     * 
     * @return The duration, in seconds, that the session should last. Acceptable durations for federation sessions
     *         range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as the
     *         default. Sessions obtained using AWS account (root) credentials are restricted to a maximum of 3600
     *         seconds (one hour). If the specified duration is longer than one hour, the session obtained by using AWS
     *         account (root) credentials defaults to one hour.
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        hashCode = 31 * hashCode + ((durationSeconds() == null) ? 0 : durationSeconds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenRequest)) {
            return false;
        }
        GetFederationTokenRequest other = (GetFederationTokenRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.durationSeconds() == null ^ this.durationSeconds() == null) {
            return false;
        }
        if (other.durationSeconds() != null && !other.durationSeconds().equals(this.durationSeconds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(durationSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetFederationTokenRequest> {
        /**
         * <p>
         * The name of the federated user. The name is used as an identifier for the temporary security credentials
         * (such as <code>Bob</code>). For example, you can reference the federated user name in a resource-based
         * policy, such as in an Amazon S3 bucket policy.
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@-
         * </p>
         * 
         * @param name
         *        The name of the federated user. The name is used as an identifier for the temporary security
         *        credentials (such as <code>Bob</code>). For example, you can reference the federated user name in a
         *        resource-based policy, such as in an Amazon S3 bucket policy.</p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An IAM policy in JSON format that is passed with the <code>GetFederationToken</code> call and evaluated along
         * with the policy or policies that are attached to the IAM user whose credentials are used to call
         * <code>GetFederationToken</code>. The passed policy is used to scope down the permissions that are available
         * to the IAM user, by allowing only a subset of the permissions that are granted to the IAM user. The passed
         * policy cannot grant more permissions than those granted to the IAM user. The final permissions for the
         * federated user are the most restrictive set based on the intersection of the passed policy and the IAM user
         * policy.
         * </p>
         * <p>
         * If you do not pass a policy, the resulting temporary security credentials have no effective permissions. The
         * only exception is when the temporary security credentials are used to access a resource that has a
         * resource-based policy that specifically allows the federated user to access the resource.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         * characters in length. The characters can be any ASCII character from the space character to the end of the
         * valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
         * packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage how
         * close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
         * </p>
         * </note>
         * <p>
         * For more information about how permissions work, see <a href=
         * "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html"
         * >Permissions for GetFederationToken</a>.
         * </p>
         * 
         * @param policy
         *        An IAM policy in JSON format that is passed with the <code>GetFederationToken</code> call and
         *        evaluated along with the policy or policies that are attached to the IAM user whose credentials are
         *        used to call <code>GetFederationToken</code>. The passed policy is used to scope down the permissions
         *        that are available to the IAM user, by allowing only a subset of the permissions that are granted to
         *        the IAM user. The passed policy cannot grant more permissions than those granted to the IAM user. The
         *        final permissions for the federated user are the most restrictive set based on the intersection of the
         *        passed policy and the IAM user policy.</p>
         *        <p>
         *        If you do not pass a policy, the resulting temporary security credentials have no effective
         *        permissions. The only exception is when the temporary security credentials are used to access a
         *        resource that has a resource-based policy that specifically allows the federated user to access the
         *        resource.
         *        </p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         *        characters in length. The characters can be any ASCII character from the space character to the end of
         *        the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage
         *        return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it
         *        into a packed binary format with a separate limit. The PackedPolicySize response element indicates by
         *        percentage how close to the upper size limit the policy is, with 100% equaling the maximum allowed
         *        size.
         *        </p>
         *        </note>
         *        <p>
         *        For more information about how permissions work, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html"
         *        >Permissions for GetFederationToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The duration, in seconds, that the session should last. Acceptable durations for federation sessions range
         * from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as the default.
         * Sessions obtained using AWS account (root) credentials are restricted to a maximum of 3600 seconds (one
         * hour). If the specified duration is longer than one hour, the session obtained by using AWS account (root)
         * credentials defaults to one hour.
         * </p>
         * 
         * @param durationSeconds
         *        The duration, in seconds, that the session should last. Acceptable durations for federation sessions
         *        range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as the
         *        default. Sessions obtained using AWS account (root) credentials are restricted to a maximum of 3600
         *        seconds (one hour). If the specified duration is longer than one hour, the session obtained by using
         *        AWS account (root) credentials defaults to one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String policy;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenRequest model) {
            setName(model.name);
            setPolicy(model.policy);
            setDurationSeconds(model.durationSeconds);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public GetFederationTokenRequest build() {
            return new GetFederationTokenRequest(this);
        }
    }
}
