/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.internal;

import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.securitytoken.ProfileCredentialsService;
import software.amazon.awssdk.auth.profile.internal.securitytoken.RoleInfo;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.STSClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class StsProfileCredentialsService
implements ProfileCredentialsService {
    @ReviewBeforeRelease(value="How should the STS client be cleaned up?")
    public AwsCredentialsProvider getAssumeRoleCredentialsProvider(RoleInfo targetRoleInfo) {
        AssumeRoleRequest assumeRoleRequest = (AssumeRoleRequest)((Object)AssumeRoleRequest.builder().roleArn(targetRoleInfo.getRoleArn()).roleSessionName(targetRoleInfo.getRoleSessionName()).externalId(targetRoleInfo.getExternalId()).build());
        STSClient stsClient = (STSClient)((STSClientBuilder)STSClient.builder().credentialsProvider(targetRoleInfo.getLongLivedCredentialsProvider())).build();
        return (AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest(assumeRoleRequest).stsClient(stsClient)).build();
    }
}

