/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>AssumeRoleWithWebIdentity</a> request, including temporary AWS credentials
 * that can be used to make AWS requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssumeRoleWithWebIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssumeRoleWithWebIdentityResponse.Builder, AssumeRoleWithWebIdentityResponse> {
    private final Credentials credentials;

    private final String subjectFromWebIdentityToken;

    private final AssumedRoleUser assumedRoleUser;

    private final Integer packedPolicySize;

    private final String provider;

    private final String audience;

    private AssumeRoleWithWebIdentityResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.subjectFromWebIdentityToken = builder.subjectFromWebIdentityToken;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.provider = builder.provider;
        this.audience = builder.audience;
    }

    /**
     * <p>
     * The temporary security credentials, which include an access key ID, a secret access key, and a security token.
     * </p>
     * <p>
     * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
     * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
     * that can vary. Also, future updates to AWS might require larger sizes.
     * </p>
     * 
     * @return The temporary security credentials, which include an access key ID, a secret access key, and a security
     *         token.</p>
     *         <p>
     *         <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that
     *         you make no assumptions about the maximum size. As of this writing, the typical size is less than 4096
     *         bytes, but that can vary. Also, future updates to AWS might require larger sizes.
     */
    public Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The unique user identifier that is returned by the identity provider. This identifier is associated with the
     * <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The
     * identifier is typically unique to the user and the application that acquired the <code>WebIdentityToken</code>
     * (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity
     * provider as the token's <code>sub</code> (Subject) claim.
     * </p>
     * 
     * @return The unique user identifier that is returned by the identity provider. This identifier is associated with
     *         the <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code>
     *         call. The identifier is typically unique to the user and the application that acquired the
     *         <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains
     *         the value returned by the identity provider as the token's <code>sub</code> (Subject) claim.
     */
    public String subjectFromWebIdentityToken() {
        return subjectFromWebIdentityToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the
     * resulting temporary security credentials. For example, you can reference these credentials as a principal in a
     * resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
     * <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer
     *         to the resulting temporary security credentials. For example, you can reference these credentials as a
     *         principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
     *         <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
     */
    public AssumedRoleUser assumedRoleUser() {
        return assumedRoleUser;
    }

    /**
     * <p>
     * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with a
     * packed size greater than 100 percent, which means the policy exceeded the allowed space.
     * </p>
     * 
     * @return A percentage value that indicates the size of the policy in packed form. The service rejects any policy
     *         with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
     */
    public Integer packedPolicySize() {
        return packedPolicySize;
    }

    /**
     * <p>
     * The issuing authority of the web identity token presented. For OpenID Connect ID Tokens this contains the value
     * of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the
     * <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.
     * </p>
     * 
     * @return The issuing authority of the web identity token presented. For OpenID Connect ID Tokens this contains the
     *         value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the
     *         <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.
     */
    public String provider() {
        return provider;
    }

    /**
     * <p>
     * The intended audience (also known as client ID) of the web identity token. This is traditionally the client
     * identifier issued to the application that requested the web identity token.
     * </p>
     * 
     * @return The intended audience (also known as client ID) of the web identity token. This is traditionally the
     *         client identifier issued to the application that requested the web identity token.
     */
    public String audience() {
        return audience;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((credentials() == null) ? 0 : credentials().hashCode());
        hashCode = 31 * hashCode + ((subjectFromWebIdentityToken() == null) ? 0 : subjectFromWebIdentityToken().hashCode());
        hashCode = 31 * hashCode + ((assumedRoleUser() == null) ? 0 : assumedRoleUser().hashCode());
        hashCode = 31 * hashCode + ((packedPolicySize() == null) ? 0 : packedPolicySize().hashCode());
        hashCode = 31 * hashCode + ((provider() == null) ? 0 : provider().hashCode());
        hashCode = 31 * hashCode + ((audience() == null) ? 0 : audience().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithWebIdentityResponse)) {
            return false;
        }
        AssumeRoleWithWebIdentityResponse other = (AssumeRoleWithWebIdentityResponse) obj;
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.subjectFromWebIdentityToken() == null ^ this.subjectFromWebIdentityToken() == null) {
            return false;
        }
        if (other.subjectFromWebIdentityToken() != null
                && !other.subjectFromWebIdentityToken().equals(this.subjectFromWebIdentityToken())) {
            return false;
        }
        if (other.assumedRoleUser() == null ^ this.assumedRoleUser() == null) {
            return false;
        }
        if (other.assumedRoleUser() != null && !other.assumedRoleUser().equals(this.assumedRoleUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        if (other.packedPolicySize() != null && !other.packedPolicySize().equals(this.packedPolicySize())) {
            return false;
        }
        if (other.provider() == null ^ this.provider() == null) {
            return false;
        }
        if (other.provider() != null && !other.provider().equals(this.provider())) {
            return false;
        }
        if (other.audience() == null ^ this.audience() == null) {
            return false;
        }
        if (other.audience() != null && !other.audience().equals(this.audience())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (credentials() != null) {
            sb.append("Credentials: ").append(credentials()).append(",");
        }
        if (subjectFromWebIdentityToken() != null) {
            sb.append("SubjectFromWebIdentityToken: ").append(subjectFromWebIdentityToken()).append(",");
        }
        if (assumedRoleUser() != null) {
            sb.append("AssumedRoleUser: ").append(assumedRoleUser()).append(",");
        }
        if (packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(packedPolicySize()).append(",");
        }
        if (provider() != null) {
            sb.append("Provider: ").append(provider()).append(",");
        }
        if (audience() != null) {
            sb.append("Audience: ").append(audience()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.of(clazz.cast(credentials()));
        case "SubjectFromWebIdentityToken":
            return Optional.of(clazz.cast(subjectFromWebIdentityToken()));
        case "AssumedRoleUser":
            return Optional.of(clazz.cast(assumedRoleUser()));
        case "PackedPolicySize":
            return Optional.of(clazz.cast(packedPolicySize()));
        case "Provider":
            return Optional.of(clazz.cast(provider()));
        case "Audience":
            return Optional.of(clazz.cast(audience()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AssumeRoleWithWebIdentityResponse> {
        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security
         * token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials, which include an access key ID, a secret access key, and a
         *        security token.</p>
         *        <p>
         *        <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend
         *        that you make no assumptions about the maximum size. As of this writing, the typical size is less than
         *        4096 bytes, but that can vary. Also, future updates to AWS might require larger sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The unique user identifier that is returned by the identity provider. This identifier is associated with the
         * <code>WebIdentityToken</code> that was submitted with the <code>AssumeRoleWithWebIdentity</code> call. The
         * identifier is typically unique to the user and the application that acquired the
         * <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect ID tokens, this field contains the
         * value returned by the identity provider as the token's <code>sub</code> (Subject) claim.
         * </p>
         * 
         * @param subjectFromWebIdentityToken
         *        The unique user identifier that is returned by the identity provider. This identifier is associated
         *        with the <code>WebIdentityToken</code> that was submitted with the
         *        <code>AssumeRoleWithWebIdentity</code> call. The identifier is typically unique to the user and the
         *        application that acquired the <code>WebIdentityToken</code> (pairwise identifier). For OpenID Connect
         *        ID tokens, this field contains the value returned by the identity provider as the token's
         *        <code>sub</code> (Subject) claim.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectFromWebIdentityToken(String subjectFromWebIdentityToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to
         * the resulting temporary security credentials. For example, you can reference these credentials as a principal
         * in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
         * <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
         * </p>
         * 
         * @param assumedRoleUser
         *        The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to
         *        refer to the resulting temporary security credentials. For example, you can reference these
         *        credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and
         *        ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRoleUser(AssumedRoleUser assumedRoleUser);

        /**
         * <p>
         * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with
         * a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * </p>
         * 
         * @param packedPolicySize
         *        A percentage value that indicates the size of the policy in packed form. The service rejects any
         *        policy with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packedPolicySize(Integer packedPolicySize);

        /**
         * <p>
         * The issuing authority of the web identity token presented. For OpenID Connect ID Tokens this contains the
         * value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the
         * <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code> request.
         * </p>
         * 
         * @param provider
         *        The issuing authority of the web identity token presented. For OpenID Connect ID Tokens this contains
         *        the value of the <code>iss</code> field. For OAuth 2.0 access tokens, this contains the value of the
         *        <code>ProviderId</code> parameter that was passed in the <code>AssumeRoleWithWebIdentity</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The intended audience (also known as client ID) of the web identity token. This is traditionally the client
         * identifier issued to the application that requested the web identity token.
         * </p>
         * 
         * @param audience
         *        The intended audience (also known as client ID) of the web identity token. This is traditionally the
         *        client identifier issued to the application that requested the web identity token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);
    }

    static final class BuilderImpl implements Builder {
        private Credentials credentials;

        private String subjectFromWebIdentityToken;

        private AssumedRoleUser assumedRoleUser;

        private Integer packedPolicySize;

        private String provider;

        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithWebIdentityResponse model) {
            credentials(model.credentials);
            subjectFromWebIdentityToken(model.subjectFromWebIdentityToken);
            assumedRoleUser(model.assumedRoleUser);
            packedPolicySize(model.packedPolicySize);
            provider(model.provider);
            audience(model.audience);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final String getSubjectFromWebIdentityToken() {
            return subjectFromWebIdentityToken;
        }

        @Override
        public final Builder subjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
            return this;
        }

        public final void setSubjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return assumedRoleUser != null ? assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getProvider() {
            return provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getAudience() {
            return audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public AssumeRoleWithWebIdentityResponse build() {
            return new AssumeRoleWithWebIdentityResponse(this);
        }
    }
}
