/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS credentials for API authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Credentials implements ToCopyableBuilder<Credentials.Builder, Credentials> {
    private final String accessKeyId;

    private final String secretAccessKey;

    private final String sessionToken;

    private final Instant expiration;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The access key ID that identifies the temporary security credentials.
     * </p>
     * 
     * @return The access key ID that identifies the temporary security credentials.
     */
    public String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The secret access key that can be used to sign requests.
     * </p>
     * 
     * @return The secret access key that can be used to sign requests.
     */
    public String secretAccessKey() {
        return secretAccessKey;
    }

    /**
     * <p>
     * The token that users must pass to the service API to use the temporary credentials.
     * </p>
     * 
     * @return The token that users must pass to the service API to use the temporary credentials.
     */
    public String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * The date on which the current credentials expire.
     * </p>
     * 
     * @return The date on which the current credentials expire.
     */
    public Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accessKeyId() == null) ? 0 : accessKeyId().hashCode());
        hashCode = 31 * hashCode + ((secretAccessKey() == null) ? 0 : secretAccessKey().hashCode());
        hashCode = 31 * hashCode + ((sessionToken() == null) ? 0 : sessionToken().hashCode());
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials) obj;
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        if (other.accessKeyId() != null && !other.accessKeyId().equals(this.accessKeyId())) {
            return false;
        }
        if (other.secretAccessKey() == null ^ this.secretAccessKey() == null) {
            return false;
        }
        if (other.secretAccessKey() != null && !other.secretAccessKey().equals(this.secretAccessKey())) {
            return false;
        }
        if (other.sessionToken() == null ^ this.sessionToken() == null) {
            return false;
        }
        if (other.sessionToken() != null && !other.sessionToken().equals(this.sessionToken())) {
            return false;
        }
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(accessKeyId()).append(",");
        }
        if (secretAccessKey() != null) {
            sb.append("SecretAccessKey: ").append(secretAccessKey()).append(",");
        }
        if (sessionToken() != null) {
            sb.append("SessionToken: ").append(sessionToken()).append(",");
        }
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyId":
            return Optional.of(clazz.cast(accessKeyId()));
        case "SecretAccessKey":
            return Optional.of(clazz.cast(secretAccessKey()));
        case "SessionToken":
            return Optional.of(clazz.cast(sessionToken()));
        case "Expiration":
            return Optional.of(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Credentials> {
        /**
         * <p>
         * The access key ID that identifies the temporary security credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The access key ID that identifies the temporary security credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The secret access key that can be used to sign requests.
         * </p>
         * 
         * @param secretAccessKey
         *        The secret access key that can be used to sign requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessKey(String secretAccessKey);

        /**
         * <p>
         * The token that users must pass to the service API to use the temporary credentials.
         * </p>
         * 
         * @param sessionToken
         *        The token that users must pass to the service API to use the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * The date on which the current credentials expire.
         * </p>
         * 
         * @param expiration
         *        The date on which the current credentials expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String secretAccessKey;

        private String sessionToken;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            accessKeyId(model.accessKeyId);
            secretAccessKey(model.secretAccessKey);
            sessionToken(model.sessionToken);
            expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretAccessKey() {
            return secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }
    }
}
