/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document that contains additional information about the authorization status of a request from an encoded message
 * that is returned in response to an AWS request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DecodeAuthorizationMessageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DecodeAuthorizationMessageResponse.Builder, DecodeAuthorizationMessageResponse> {
    private final String decodedMessage;

    private DecodeAuthorizationMessageResponse(BuilderImpl builder) {
        this.decodedMessage = builder.decodedMessage;
    }

    /**
     * <p>
     * An XML document that contains the decoded message.
     * </p>
     * 
     * @return An XML document that contains the decoded message.
     */
    public String decodedMessage() {
        return decodedMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((decodedMessage() == null) ? 0 : decodedMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecodeAuthorizationMessageResponse)) {
            return false;
        }
        DecodeAuthorizationMessageResponse other = (DecodeAuthorizationMessageResponse) obj;
        if (other.decodedMessage() == null ^ this.decodedMessage() == null) {
            return false;
        }
        if (other.decodedMessage() != null && !other.decodedMessage().equals(this.decodedMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (decodedMessage() != null) {
            sb.append("DecodedMessage: ").append(decodedMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecodedMessage":
            return Optional.of(clazz.cast(decodedMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DecodeAuthorizationMessageResponse> {
        /**
         * <p>
         * An XML document that contains the decoded message.
         * </p>
         * 
         * @param decodedMessage
         *        An XML document that contains the decoded message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decodedMessage(String decodedMessage);
    }

    static final class BuilderImpl implements Builder {
        private String decodedMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DecodeAuthorizationMessageResponse model) {
            decodedMessage(model.decodedMessage);
        }

        public final String getDecodedMessage() {
            return decodedMessage;
        }

        @Override
        public final Builder decodedMessage(String decodedMessage) {
            this.decodedMessage = decodedMessage;
            return this;
        }

        public final void setDecodedMessage(String decodedMessage) {
            this.decodedMessage = decodedMessage;
        }

        @Override
        public DecodeAuthorizationMessageResponse build() {
            return new DecodeAuthorizationMessageResponse(this);
        }
    }
}
