/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetFederationToken</a> request, including temporary AWS credentials that can
 * be used to make AWS requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetFederationTokenResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetFederationTokenResponse.Builder, GetFederationTokenResponse> {
    private final Credentials credentials;

    private final FederatedUser federatedUser;

    private final Integer packedPolicySize;

    private GetFederationTokenResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.federatedUser = builder.federatedUser;
        this.packedPolicySize = builder.packedPolicySize;
    }

    /**
     * <p>
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
     * session) token.
     * </p>
     * <p>
     * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
     * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
     * that can vary. Also, future updates to AWS might require larger sizes.
     * </p>
     * 
     * @return The temporary security credentials, which include an access key ID, a secret access key, and a security
     *         (or session) token.</p>
     *         <p>
     *         <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that
     *         you make no assumptions about the maximum size. As of this writing, the typical size is less than 4096
     *         bytes, but that can vary. Also, future updates to AWS might require larger sizes.
     */
    public Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * Identifiers for the federated user associated with the credentials (such as
     * <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the
     * federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy.
     * </p>
     * 
     * @return Identifiers for the federated user associated with the credentials (such as
     *         <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use
     *         the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy.
     */
    public FederatedUser federatedUser() {
        return federatedUser;
    }

    /**
     * <p>
     * A percentage value indicating the size of the policy in packed form. The service rejects policies for which the
     * packed size is greater than 100 percent of the allowed value.
     * </p>
     * 
     * @return A percentage value indicating the size of the policy in packed form. The service rejects policies for
     *         which the packed size is greater than 100 percent of the allowed value.
     */
    public Integer packedPolicySize() {
        return packedPolicySize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((credentials() == null) ? 0 : credentials().hashCode());
        hashCode = 31 * hashCode + ((federatedUser() == null) ? 0 : federatedUser().hashCode());
        hashCode = 31 * hashCode + ((packedPolicySize() == null) ? 0 : packedPolicySize().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenResponse)) {
            return false;
        }
        GetFederationTokenResponse other = (GetFederationTokenResponse) obj;
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.federatedUser() == null ^ this.federatedUser() == null) {
            return false;
        }
        if (other.federatedUser() != null && !other.federatedUser().equals(this.federatedUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        if (other.packedPolicySize() != null && !other.packedPolicySize().equals(this.packedPolicySize())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (credentials() != null) {
            sb.append("Credentials: ").append(credentials()).append(",");
        }
        if (federatedUser() != null) {
            sb.append("FederatedUser: ").append(federatedUser()).append(",");
        }
        if (packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(packedPolicySize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.of(clazz.cast(credentials()));
        case "FederatedUser":
            return Optional.of(clazz.cast(federatedUser()));
        case "PackedPolicySize":
            return Optional.of(clazz.cast(packedPolicySize()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetFederationTokenResponse> {
        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
         * session) token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials, which include an access key ID, a secret access key, and a
         *        security (or session) token.</p>
         *        <p>
         *        <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend
         *        that you make no assumptions about the maximum size. As of this writing, the typical size is less than
         *        4096 bytes, but that can vary. Also, future updates to AWS might require larger sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * Identifiers for the federated user associated with the credentials (such as
         * <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can use the
         * federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy.
         * </p>
         * 
         * @param federatedUser
         *        Identifiers for the federated user associated with the credentials (such as
         *        <code>arn:aws:sts::123456789012:federated-user/Bob</code> or <code>123456789012:Bob</code>). You can
         *        use the federated user's ARN in your resource-based policies, such as an Amazon S3 bucket policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedUser(FederatedUser federatedUser);

        /**
         * <p>
         * A percentage value indicating the size of the policy in packed form. The service rejects policies for which
         * the packed size is greater than 100 percent of the allowed value.
         * </p>
         * 
         * @param packedPolicySize
         *        A percentage value indicating the size of the policy in packed form. The service rejects policies for
         *        which the packed size is greater than 100 percent of the allowed value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packedPolicySize(Integer packedPolicySize);
    }

    static final class BuilderImpl implements Builder {
        private Credentials credentials;

        private FederatedUser federatedUser;

        private Integer packedPolicySize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenResponse model) {
            credentials(model.credentials);
            federatedUser(model.federatedUser);
            packedPolicySize(model.packedPolicySize);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final FederatedUser.Builder getFederatedUser() {
            return federatedUser != null ? federatedUser.toBuilder() : null;
        }

        @Override
        public final Builder federatedUser(FederatedUser federatedUser) {
            this.federatedUser = federatedUser;
            return this;
        }

        public final void setFederatedUser(FederatedUser.BuilderImpl federatedUser) {
            this.federatedUser = federatedUser != null ? federatedUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public GetFederationTokenResponse build() {
            return new GetFederationTokenResponse(this);
        }
    }
}
