/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetSessionToken</a> request, including temporary AWS credentials that can be
 * used to make AWS requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSessionTokenResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSessionTokenResponse.Builder, GetSessionTokenResponse> {
    private final Credentials credentials;

    private GetSessionTokenResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
     * session) token.
     * </p>
     * <p>
     * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
     * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
     * that can vary. Also, future updates to AWS might require larger sizes.
     * </p>
     * 
     * @return The temporary security credentials, which include an access key ID, a secret access key, and a security
     *         (or session) token.</p>
     *         <p>
     *         <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that
     *         you make no assumptions about the maximum size. As of this writing, the typical size is less than 4096
     *         bytes, but that can vary. Also, future updates to AWS might require larger sizes.
     */
    public Credentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((credentials() == null) ? 0 : credentials().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionTokenResponse)) {
            return false;
        }
        GetSessionTokenResponse other = (GetSessionTokenResponse) obj;
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (credentials() != null) {
            sb.append("Credentials: ").append(credentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.of(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetSessionTokenResponse> {
        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
         * session) token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials, which include an access key ID, a secret access key, and a
         *        security (or session) token.</p>
         *        <p>
         *        <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend
         *        that you make no assumptions about the maximum size. As of this writing, the typical size is less than
         *        4096 bytes, but that can vary. Also, future updates to AWS might require larger sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);
    }

    static final class BuilderImpl implements Builder {
        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionTokenResponse model) {
            credentials(model.credentials);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public GetSessionTokenResponse build() {
            return new GetSessionTokenResponse(this);
        }
    }
}
