/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFederationTokenRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetFederationTokenRequest> {
    private final String name;
    private final String policy;
    private final Integer durationSeconds;

    private GetFederationTokenRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    public String name() {
        return this.name;
    }

    public String policy() {
        return this.policy;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.policy() == null ? 0 : this.policy().hashCode());
        hashCode = 31 * hashCode + (this.durationSeconds() == null ? 0 : this.durationSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenRequest)) {
            return false;
        }
        GetFederationTokenRequest other = (GetFederationTokenRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.durationSeconds() == null ^ this.durationSeconds() == null) {
            return false;
        }
        return other.durationSeconds() == null || other.durationSeconds().equals(this.durationSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        if (this.durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(this.durationSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String policy;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenRequest model) {
            this.name(model.name);
            this.policy(model.policy);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public GetFederationTokenRequest build() {
            return new GetFederationTokenRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFederationTokenRequest> {
        public Builder name(String var1);

        public Builder policy(String var1);

        public Builder durationSeconds(Integer var1);
    }
}

