/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        if (assumeRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assumeRoleRequest, "STSClient");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)assumeRoleRequest.roleArn()));
        }
        if (assumeRoleRequest.roleSessionName() != null) {
            request.addParameter("RoleSessionName", StringUtils.fromString((String)assumeRoleRequest.roleSessionName()));
        }
        if (assumeRoleRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)assumeRoleRequest.policy()));
        }
        if (assumeRoleRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)assumeRoleRequest.durationSeconds()));
        }
        if (assumeRoleRequest.externalId() != null) {
            request.addParameter("ExternalId", StringUtils.fromString((String)assumeRoleRequest.externalId()));
        }
        if (assumeRoleRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)assumeRoleRequest.serialNumber()));
        }
        if (assumeRoleRequest.tokenCode() != null) {
            request.addParameter("TokenCode", StringUtils.fromString((String)assumeRoleRequest.tokenCode()));
        }
        return request;
    }
}

