/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request could not be fulfilled because the non-AWS identity provider (IDP) that was asked to verify the incoming
 * identity token could not be reached. This is often a transient error caused by network conditions. Retry the request
 * a limited number of times so that you don't exceed the request rate. If the error persists, the non-AWS identity
 * provider might be down or not responding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IDPCommunicationErrorException extends STSException implements
        ToCopyableBuilder<IDPCommunicationErrorException.Builder, IDPCommunicationErrorException> {
    private IDPCommunicationErrorException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, IDPCommunicationErrorException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(IDPCommunicationErrorException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public IDPCommunicationErrorException build() {
            return new IDPCommunicationErrorException(this);
        }
    }
}
