/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sts.model.STSResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCallerIdentityResponse
extends STSResponse
implements ToCopyableBuilder<Builder, GetCallerIdentityResponse> {
    private final String userId;
    private final String account;
    private final String arn;

    private GetCallerIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.account = builder.account;
        this.arn = builder.arn;
    }

    public String userId() {
        return this.userId;
    }

    public String account() {
        return this.account;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCallerIdentityResponse)) {
            return false;
        }
        GetCallerIdentityResponse other = (GetCallerIdentityResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.account(), other.account()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.account() != null) {
            sb.append("Account: ").append(this.account()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "Account": {
                return Optional.of(clazz.cast(this.account()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String account;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCallerIdentityResponse model) {
            this.userId(model.userId);
            this.account(model.account);
            this.arn(model.arn);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public GetCallerIdentityResponse build() {
            return new GetCallerIdentityResponse(this);
        }
    }

    public static interface Builder
    extends STSResponse.Builder,
    CopyableBuilder<Builder, GetCallerIdentityResponse> {
        public Builder userId(String var1);

        public Builder account(String var1);

        public Builder arn(String var1);
    }
}

