/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document that contains additional information about the authorization status of a request from an encoded message
 * that is returned in response to an AWS request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DecodeAuthorizationMessageResponse extends STSResponse implements
        ToCopyableBuilder<DecodeAuthorizationMessageResponse.Builder, DecodeAuthorizationMessageResponse> {
    private final String decodedMessage;

    private DecodeAuthorizationMessageResponse(BuilderImpl builder) {
        super(builder);
        this.decodedMessage = builder.decodedMessage;
    }

    /**
     * <p>
     * An XML document that contains the decoded message.
     * </p>
     * 
     * @return An XML document that contains the decoded message.
     */
    public String decodedMessage() {
        return decodedMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decodedMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecodeAuthorizationMessageResponse)) {
            return false;
        }
        DecodeAuthorizationMessageResponse other = (DecodeAuthorizationMessageResponse) obj;
        return Objects.equals(decodedMessage(), other.decodedMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("DecodeAuthorizationMessageResponse").add("DecodedMessage", decodedMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecodedMessage":
            return Optional.of(clazz.cast(decodedMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends STSResponse.Builder, CopyableBuilder<Builder, DecodeAuthorizationMessageResponse> {
        /**
         * <p>
         * An XML document that contains the decoded message.
         * </p>
         * 
         * @param decodedMessage
         *        An XML document that contains the decoded message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decodedMessage(String decodedMessage);
    }

    static final class BuilderImpl extends STSResponse.BuilderImpl implements Builder {
        private String decodedMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DecodeAuthorizationMessageResponse model) {
            decodedMessage(model.decodedMessage);
        }

        public final String getDecodedMessage() {
            return decodedMessage;
        }

        @Override
        public final Builder decodedMessage(String decodedMessage) {
            this.decodedMessage = decodedMessage;
            return this;
        }

        public final void setDecodedMessage(String decodedMessage) {
            this.decodedMessage = decodedMessage;
        }

        @Override
        public DecodeAuthorizationMessageResponse build() {
            return new DecodeAuthorizationMessageResponse(this);
        }
    }
}
