/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error returned if the message passed to <code>DecodeAuthorizationMessage</code> was invalid. This can happen if
 * the token contains invalid characters, such as linebreaks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidAuthorizationMessageException extends STSException implements
        ToCopyableBuilder<InvalidAuthorizationMessageException.Builder, InvalidAuthorizationMessageException> {
    private InvalidAuthorizationMessageException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidAuthorizationMessageException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidAuthorizationMessageException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidAuthorizationMessageException build() {
            return new InvalidAuthorizationMessageException(this);
        }
    }
}
