/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sts.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AssumeRoleWithSAMLRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssumeRoleWithSAMLRequestMarshaller implements
        Marshaller<Request<AssumeRoleWithSAMLRequest>, AssumeRoleWithSAMLRequest> {

    public Request<AssumeRoleWithSAMLRequest> marshall(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {

        if (assumeRoleWithSAMLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AssumeRoleWithSAMLRequest> request = new DefaultRequest<AssumeRoleWithSAMLRequest>(assumeRoleWithSAMLRequest,
                "STSClient");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (assumeRoleWithSAMLRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(assumeRoleWithSAMLRequest.roleArn()));
        }

        if (assumeRoleWithSAMLRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringUtils.fromString(assumeRoleWithSAMLRequest.principalArn()));
        }

        if (assumeRoleWithSAMLRequest.samlAssertion() != null) {
            request.addParameter("SAMLAssertion", StringUtils.fromString(assumeRoleWithSAMLRequest.samlAssertion()));
        }

        if (assumeRoleWithSAMLRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString(assumeRoleWithSAMLRequest.policy()));
        }

        if (assumeRoleWithSAMLRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger(assumeRoleWithSAMLRequest.durationSeconds()));
        }

        return request;
    }

}
