/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sts.model.STSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleRequest
extends STSRequest
implements ToCopyableBuilder<Builder, AssumeRoleRequest> {
    private final String roleArn;
    private final String roleSessionName;
    private final String policy;
    private final Integer durationSeconds;
    private final String externalId;
    private final String serialNumber;
    private final String tokenCode;

    private AssumeRoleRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
        this.externalId = builder.externalId;
        this.serialNumber = builder.serialNumber;
        this.tokenCode = builder.tokenCode;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String roleSessionName() {
        return this.roleSessionName;
    }

    public String policy() {
        return this.policy;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public String externalId() {
        return this.externalId;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String tokenCode() {
        return this.tokenCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleRequest)) {
            return false;
        }
        AssumeRoleRequest other = (AssumeRoleRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.roleSessionName(), other.roleSessionName()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.tokenCode(), other.tokenCode());
    }

    public String toString() {
        return ToString.builder((String)"AssumeRoleRequest").add("RoleArn", (Object)this.roleArn()).add("RoleSessionName", (Object)this.roleSessionName()).add("Policy", (Object)this.policy()).add("DurationSeconds", (Object)this.durationSeconds()).add("ExternalId", (Object)this.externalId()).add("SerialNumber", (Object)this.serialNumber()).add("TokenCode", (Object)this.tokenCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "RoleSessionName": {
                return Optional.of(clazz.cast(this.roleSessionName()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
            case "ExternalId": {
                return Optional.of(clazz.cast(this.externalId()));
            }
            case "SerialNumber": {
                return Optional.of(clazz.cast(this.serialNumber()));
            }
            case "TokenCode": {
                return Optional.of(clazz.cast(this.tokenCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private String roleSessionName;
        private String policy;
        private Integer durationSeconds;
        private String externalId;
        private String serialNumber;
        private String tokenCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleRequest model) {
            this.roleArn(model.roleArn);
            this.roleSessionName(model.roleSessionName);
            this.policy(model.policy);
            this.durationSeconds(model.durationSeconds);
            this.externalId(model.externalId);
            this.serialNumber(model.serialNumber);
            this.tokenCode(model.tokenCode);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getRoleSessionName() {
            return this.roleSessionName;
        }

        @Override
        public final Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public final void setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getTokenCode() {
            return this.tokenCode;
        }

        @Override
        public final Builder tokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
            return this;
        }

        public final void setTokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssumeRoleRequest build() {
            return new AssumeRoleRequest(this);
        }
    }

    public static interface Builder
    extends STSRequest.Builder,
    CopyableBuilder<Builder, AssumeRoleRequest> {
        public Builder roleArn(String var1);

        public Builder roleSessionName(String var1);

        public Builder policy(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder externalId(String var1);

        public Builder serialNumber(String var1);

        public Builder tokenCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

