/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.utils.CollectionUtils;

/**
 * Internal implementation of {@link StsClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStsClientBuilder extends DefaultStsBaseClientBuilder<StsClientBuilder, StsClient> implements StsClientBuilder {
    @Override
    public DefaultStsClientBuilder endpointProvider(StsEndpointProvider endpointProvider) {
        clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final StsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        List<ExecutionInterceptor> interceptors = clientConfiguration.option(SdkClientOption.EXECUTION_INTERCEPTORS);
        List<ExecutionInterceptor> queryParamsToBodyInterceptor = Collections
                .singletonList(new QueryParametersToBodyInterceptor());
        List<ExecutionInterceptor> customizationInterceptors = new ArrayList<>();
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors)
                .build();
        this.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null
                && Boolean.TRUE.equals(clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfiguration.option(SdkClientOption.ENDPOINT);
        }
        StsServiceClientConfiguration serviceClientConfiguration = StsServiceClientConfiguration.builder()
                .overrideConfiguration(overrideConfiguration()).region(clientConfiguration.option(AwsClientOption.AWS_REGION))
                .endpointOverride(endpointOverride).build();
        return new DefaultStsClient(serviceClientConfiguration, clientConfiguration);
    }
}
