/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultStsEndpointProvider implements StsEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(StsEndpointParams endpointParams) {
        Validate.notNull(endpointParams.useDualStack(), "Parameter 'UseDualStack' must not be null");
        Validate.notNull(endpointParams.useFips(), "Parameter 'UseFIPS' must not be null");
        Validate.notNull(endpointParams.useGlobalEndpoint(), "Parameter 'UseGlobalEndpoint' must not be null");
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        } catch (Exception error) {
            return CompletableFutureUtils.failedFuture(error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(StsEndpointParams params) {
        Map<Identifier, Value> paramsMap = new HashMap<>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        if (params.useGlobalEndpoint() != null) {
            paramsMap.put(Identifier.of("UseGlobalEndpoint"), Value.fromBool(params.useGlobalEndpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-1")))
                                        .build().validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_2() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-south-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_3() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-1")))
                                        .build().validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_4() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-2")))
                                        .build().validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_5() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_6() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ca-central-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_7() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-central-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-north-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_9() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_10() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-2"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_11() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-3"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_12() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("sa-east-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_13() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_14() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-2"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_15() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-west-1"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_16() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-west-2"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_17() {
        return Rule.builder().endpoint(
                EndpointResult
                        .builder()
                        .url(Expr.of("https://sts.{Region}.{PartitionResult#dnsSuffix}"))
                        .addProperty(
                                Identifier.of("authSchemes"),
                                Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                        Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                        Identifier.of("signingRegion"), Literal.fromStr("{Region}")))))).build());
    }

    private static Rule endpointRule_0() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("not")
                                        .argv(Arrays.asList(FnNode.builder().fn("isSet")
                                                .argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()))
                                        .build().validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region"))))
                                        .build().validate()).result("PartitionResult").build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build()
                                        .validate()).build())
                .treeRule(
                        Arrays.asList(endpointRule_1(), endpointRule_2(), endpointRule_3(), endpointRule_4(), endpointRule_5(),
                                endpointRule_6(), endpointRule_7(), endpointRule_8(), endpointRule_9(), endpointRule_10(),
                                endpointRule_11(), endpointRule_12(), endpointRule_13(), endpointRule_14(), endpointRule_15(),
                                endpointRule_16(), endpointRule_17()));
    }

    private static Rule endpointRule_19() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_20() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build())
                .error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_18() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build()
                                        .validate()).build())
                .treeRule(Arrays.asList(endpointRule_19(), endpointRule_20(), endpointRule_21()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://sts-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_25() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_26()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_24() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_25(), endpointRule_27()));
    }

    private static Rule endpointRule_30() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("stringEquals")
                                        .argv(Arrays.asList(
                                                Expr.of("aws-us-gov"),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("name"))).build().validate())).build().validate())
                                .build())
                .endpoint(EndpointResult.builder().url(Expr.of("https://sts.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_31() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://sts-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_29() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build()).treeRule(Arrays.asList(endpointRule_30(), endpointRule_31()));
    }

    private static Rule endpointRule_32() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_28() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_29(), endpointRule_32()));
    }

    private static Rule endpointRule_35() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://sts.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_34() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_35()));
    }

    private static Rule endpointRule_36() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_33() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_34(), endpointRule_36()));
    }

    private static Rule endpointRule_37() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://sts.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("sts"),
                                                Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_38() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://sts.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_23() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region"))))
                                        .build().validate()).result("PartitionResult").build())
                .treeRule(
                        Arrays.asList(endpointRule_24(), endpointRule_28(), endpointRule_33(), endpointRule_37(),
                                endpointRule_38()));
    }

    private static Rule endpointRule_22() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_23()));
    }

    private static Rule endpointRule_39() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset
                .builder()
                .version("1.0")
                .serviceId(null)
                .parameters(
                        Parameters
                                .builder()
                                .addParameter(
                                        Parameter.builder().name("Region").type(ParameterType.fromValue("String"))
                                                .required(false).builtIn("AWS::Region")
                                                .documentation("The AWS region used to dispatch the request.").build())
                                .addParameter(
                                        Parameter
                                                .builder()
                                                .name("UseDualStack")
                                                .type(ParameterType.fromValue("Boolean"))
                                                .required(true)
                                                .builtIn("AWS::UseDualStack")
                                                .documentation(
                                                        "When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.")
                                                .defaultValue(Value.fromBool(false)).build())
                                .addParameter(
                                        Parameter
                                                .builder()
                                                .name("UseFIPS")
                                                .type(ParameterType.fromValue("Boolean"))
                                                .required(true)
                                                .builtIn("AWS::UseFIPS")
                                                .documentation(
                                                        "When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.")
                                                .defaultValue(Value.fromBool(false)).build())
                                .addParameter(
                                        Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String"))
                                                .required(false).builtIn("SDK::Endpoint")
                                                .documentation("Override the endpoint used to send this request").build())
                                .addParameter(
                                        Parameter
                                                .builder()
                                                .name("UseGlobalEndpoint")
                                                .type(ParameterType.fromValue("Boolean"))
                                                .required(true)
                                                .builtIn("AWS::STS::UseGlobalEndpoint")
                                                .documentation(
                                                        "Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.")
                                                .defaultValue(Value.fromBool(false)).build()).build()).addRule(endpointRule_0())
                .addRule(endpointRule_18()).addRule(endpointRule_22()).addRule(endpointRule_39()).build();
    }
}
