/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeRoleWithSamlRequest extends StsRequest implements
        ToCopyableBuilder<AssumeRoleWithSamlRequest.Builder, AssumeRoleWithSamlRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssumeRoleWithSamlRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssumeRoleWithSamlRequest::principalArn)).setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalArn").build()).build();

    private static final SdkField<String> SAML_ASSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssumeRoleWithSamlRequest::samlAssertion)).setter(setter(Builder::samlAssertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLAssertion").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssumeRoleWithSamlRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AssumeRoleWithSamlRequest::durationSeconds)).setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            PRINCIPAL_ARN_FIELD, SAML_ASSERTION_FIELD, POLICY_FIELD, DURATION_SECONDS_FIELD));

    private final String roleArn;

    private final String principalArn;

    private final String samlAssertion;

    private final String policy;

    private final Integer durationSeconds;

    private AssumeRoleWithSamlRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.principalArn = builder.principalArn;
        this.samlAssertion = builder.samlAssertion;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that the caller is assuming.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that the caller is assuming.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     */
    public String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The base-64 encoded SAML authentication response provided by the IdP.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a Relying
     * Party and Adding Claims</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The base-64 encoded SAML authentication response provided by the IdP.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a
     *         Relying Party and Adding Claims</a> in the <i>IAM User Guide</i>.
     */
    public String samlAssertion() {
        return samlAssertion;
    }

    /**
     * <p>
     * An IAM policy in JSON format.
     * </p>
     * <p>
     * The policy parameter is optional. If you pass a policy to this operation, the resulting temporary credentials
     * have the permissions of the assumed role <i>and</i> the policy that you pass. This gives you a way to further
     * restrict the permissions for the resulting temporary security credentials. You cannot use the passed policy to
     * grant permissions that are in excess of those allowed by the permissions policy of the role that is being
     * assumed. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">
     * Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity </a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048 characters
     * in length. The characters can be any ASCII character from the space character to the end of the valid character
     * list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The policy plaintext must be 2048 bytes or shorter. However, an internal conversion compresses it into a packed
     * binary format with a separate limit. The <code>PackedPolicySize</code> response element indicates by percentage
     * how close to the upper size limit the policy is, where 100 percent is the maximum allowed size.
     * </p>
     * </note>
     * 
     * @return An IAM policy in JSON format.</p>
     *         <p>
     *         The policy parameter is optional. If you pass a policy to this operation, the resulting temporary
     *         credentials have the permissions of the assumed role <i>and</i> the policy that you pass. This gives you
     *         a way to further restrict the permissions for the resulting temporary security credentials. You cannot
     *         use the passed policy to grant permissions that are in excess of those allowed by the permissions policy
     *         of the role that is being assumed. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">
     *         Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity </a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
     *         characters in length. The characters can be any ASCII character from the space character to the end of
     *         the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return (
     *         ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The policy plaintext must be 2048 bytes or shorter. However, an internal conversion compresses it into a
     *         packed binary format with a separate limit. The <code>PackedPolicySize</code> response element indicates
     *         by percentage how close to the upper size limit the policy is, where 100 percent is the maximum allowed
     *         size.
     *         </p>
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The duration, in seconds, of the role session. Your role session lasts for the duration that you specify for the
     * <code>DurationSeconds</code> parameter, or until the time specified in the SAML authentication response's
     * <code>SessionNotOnOrAfter</code> value, whichever is shorter. You can provide a <code>DurationSeconds</code>
     * value from 900 seconds (15 minutes) up to the maximum session duration setting for the role. This setting can
     * have a value from 1 hour to 12 hours. If you specify a value higher than this setting, the operation fails. For
     * example, if you specify a session duration of 12 hours, but your administrator set the maximum session duration
     * to 6 hours, your operation fails. To learn how to view the maximum value for your role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session">View
     * the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * By default, the value is set to <code>3600</code> seconds.
     * </p>
     * <note>
     * <p>
     * The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you might
     * request using the returned credentials. The request to the federation endpoint for a console sign-in token takes
     * a <code>SessionDuration</code> parameter that specifies the maximum length of the console session. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
     * >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </note>
     * 
     * @return The duration, in seconds, of the role session. Your role session lasts for the duration that you specify
     *         for the <code>DurationSeconds</code> parameter, or until the time specified in the SAML authentication
     *         response's <code>SessionNotOnOrAfter</code> value, whichever is shorter. You can provide a
     *         <code>DurationSeconds</code> value from 900 seconds (15 minutes) up to the maximum session duration
     *         setting for the role. This setting can have a value from 1 hour to 12 hours. If you specify a value
     *         higher than this setting, the operation fails. For example, if you specify a session duration of 12
     *         hours, but your administrator set the maximum session duration to 6 hours, your operation fails. To learn
     *         how to view the maximum value for your role, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session"
     *         >View the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.</p>
     *         <p>
     *         By default, the value is set to <code>3600</code> seconds.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you
     *         might request using the returned credentials. The request to the federation endpoint for a console
     *         sign-in token takes a <code>SessionDuration</code> parameter that specifies the maximum length of the
     *         console session. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
     *         >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(samlAssertion());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSamlRequest)) {
            return false;
        }
        AssumeRoleWithSamlRequest other = (AssumeRoleWithSamlRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(samlAssertion(), other.samlAssertion()) && Objects.equals(policy(), other.policy())
                && Objects.equals(durationSeconds(), other.durationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssumeRoleWithSamlRequest").add("RoleArn", roleArn()).add("PrincipalArn", principalArn())
                .add("SAMLAssertion", samlAssertion()).add("Policy", policy()).add("DurationSeconds", durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "PrincipalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "SAMLAssertion":
            return Optional.ofNullable(clazz.cast(samlAssertion()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssumeRoleWithSamlRequest, T> g) {
        return obj -> g.apply((AssumeRoleWithSamlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssumeRoleWithSamlRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The base-64 encoded SAML authentication response provided by the IdP.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a Relying
         * Party and Adding Claims</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param samlAssertion
         *        The base-64 encoded SAML authentication response provided by the IdP.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a
         *        Relying Party and Adding Claims</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlAssertion(String samlAssertion);

        /**
         * <p>
         * An IAM policy in JSON format.
         * </p>
         * <p>
         * The policy parameter is optional. If you pass a policy to this operation, the resulting temporary credentials
         * have the permissions of the assumed role <i>and</i> the policy that you pass. This gives you a way to further
         * restrict the permissions for the resulting temporary security credentials. You cannot use the passed policy
         * to grant permissions that are in excess of those allowed by the permissions policy of the role that is being
         * assumed. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">
         * Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity </a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         * characters in length. The characters can be any ASCII character from the space character to the end of the
         * valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The policy plaintext must be 2048 bytes or shorter. However, an internal conversion compresses it into a
         * packed binary format with a separate limit. The <code>PackedPolicySize</code> response element indicates by
         * percentage how close to the upper size limit the policy is, where 100 percent is the maximum allowed size.
         * </p>
         * </note>
         * 
         * @param policy
         *        An IAM policy in JSON format.</p>
         *        <p>
         *        The policy parameter is optional. If you pass a policy to this operation, the resulting temporary
         *        credentials have the permissions of the assumed role <i>and</i> the policy that you pass. This gives
         *        you a way to further restrict the permissions for the resulting temporary security credentials. You
         *        cannot use the passed policy to grant permissions that are in excess of those allowed by the
         *        permissions policy of the role that is being assumed. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">
         *        Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity </a> in the <i>IAM User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         *        characters in length. The characters can be any ASCII character from the space character to the end of
         *        the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage
         *        return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The policy plaintext must be 2048 bytes or shorter. However, an internal conversion compresses it into
         *        a packed binary format with a separate limit. The <code>PackedPolicySize</code> response element
         *        indicates by percentage how close to the upper size limit the policy is, where 100 percent is the
         *        maximum allowed size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The duration, in seconds, of the role session. Your role session lasts for the duration that you specify for
         * the <code>DurationSeconds</code> parameter, or until the time specified in the SAML authentication response's
         * <code>SessionNotOnOrAfter</code> value, whichever is shorter. You can provide a <code>DurationSeconds</code>
         * value from 900 seconds (15 minutes) up to the maximum session duration setting for the role. This setting can
         * have a value from 1 hour to 12 hours. If you specify a value higher than this setting, the operation fails.
         * For example, if you specify a session duration of 12 hours, but your administrator set the maximum session
         * duration to 6 hours, your operation fails. To learn how to view the maximum value for your role, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session">View
         * the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * By default, the value is set to <code>3600</code> seconds.
         * </p>
         * <note>
         * <p>
         * The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you might
         * request using the returned credentials. The request to the federation endpoint for a console sign-in token
         * takes a <code>SessionDuration</code> parameter that specifies the maximum length of the console session. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         * >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param durationSeconds
         *        The duration, in seconds, of the role session. Your role session lasts for the duration that you
         *        specify for the <code>DurationSeconds</code> parameter, or until the time specified in the SAML
         *        authentication response's <code>SessionNotOnOrAfter</code> value, whichever is shorter. You can
         *        provide a <code>DurationSeconds</code> value from 900 seconds (15 minutes) up to the maximum session
         *        duration setting for the role. This setting can have a value from 1 hour to 12 hours. If you specify a
         *        value higher than this setting, the operation fails. For example, if you specify a session duration of
         *        12 hours, but your administrator set the maximum session duration to 6 hours, your operation fails. To
         *        learn how to view the maximum value for your role, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session"
         *        >View the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.</p>
         *        <p>
         *        By default, the value is set to <code>3600</code> seconds.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you
         *        might request using the returned credentials. The request to the federation endpoint for a console
         *        sign-in token takes a <code>SessionDuration</code> parameter that specifies the maximum length of the
         *        console session. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         *        >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String roleArn;

        private String principalArn;

        private String samlAssertion;

        private String policy;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSamlRequest model) {
            super(model);
            roleArn(model.roleArn);
            principalArn(model.principalArn);
            samlAssertion(model.samlAssertion);
            policy(model.policy);
            durationSeconds(model.durationSeconds);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getSamlAssertion() {
            return samlAssertion;
        }

        @Override
        public final Builder samlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
            return this;
        }

        public final void setSamlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeRoleWithSamlRequest build() {
            return new AssumeRoleWithSamlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
