/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFederationTokenRequest extends StsRequest implements
        ToCopyableBuilder<GetFederationTokenRequest.Builder, GetFederationTokenRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFederationTokenRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFederationTokenRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<List<PolicyDescriptorType>> POLICY_ARNS_FIELD = SdkField
            .<List<PolicyDescriptorType>> builder(MarshallingType.LIST)
            .getter(getter(GetFederationTokenRequest::policyArns))
            .setter(setter(Builder::policyArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyDescriptorType> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyDescriptorType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetFederationTokenRequest::durationSeconds)).setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, POLICY_FIELD,
            POLICY_ARNS_FIELD, DURATION_SECONDS_FIELD));

    private final String name;

    private final String policy;

    private final List<PolicyDescriptorType> policyArns;

    private final Integer durationSeconds;

    private GetFederationTokenRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.policy = builder.policy;
        this.policyArns = builder.policyArns;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * The name of the federated user. The name is used as an identifier for the temporary security credentials (such as
     * <code>Bob</code>). For example, you can reference the federated user name in a resource-based policy, such as in
     * an Amazon S3 bucket policy.
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     * </p>
     * 
     * @return The name of the federated user. The name is used as an identifier for the temporary security credentials
     *         (such as <code>Bob</code>). For example, you can reference the federated user name in a resource-based
     *         policy, such as in an Amazon S3 bucket policy.</p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@-
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An IAM policy in JSON format that you want to use as an inline session policy.
     * </p>
     * <p>
     * You must pass an inline or managed <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session policy</a>
     * to this operation. You can pass a single JSON policy document to use as an inline session policy. You can also
     * specify up to 10 managed policies to use as managed session policies.
     * </p>
     * <p>
     * This parameter is optional. However, if you do not pass any session policies, then the resulting federated user
     * session has no permissions. The only exception is when the credentials are used to access a resource that has a
     * resource-based policy that specifically references the federated user session in the <code>Principal</code>
     * element of the policy.
     * </p>
     * <p>
     * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
     * session policies that you pass. This gives you a way to further restrict the permissions for a federated user.
     * You cannot use session policies to grant more permissions than those that are defined in the permissions policy
     * of the IAM user. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The plain text that you use for both inline and managed session policies shouldn't exceed 2048 characters. The
     * JSON policy characters can be any ASCII character from the space character to the end of the valid character list
     * ( through \u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
     * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
     * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the policy
     * is to the upper size limit.
     * </p>
     * </note>
     * 
     * @return An IAM policy in JSON format that you want to use as an inline session policy.</p>
     *         <p>
     *         You must pass an inline or managed <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
     *         policy</a> to this operation. You can pass a single JSON policy document to use as an inline session
     *         policy. You can also specify up to 10 managed policies to use as managed session policies.
     *         </p>
     *         <p>
     *         This parameter is optional. However, if you do not pass any session policies, then the resulting
     *         federated user session has no permissions. The only exception is when the credentials are used to access
     *         a resource that has a resource-based policy that specifically references the federated user session in
     *         the <code>Principal</code> element of the policy.
     *         </p>
     *         <p>
     *         When you pass session policies, the session permissions are the intersection of the IAM user policies and
     *         the session policies that you pass. This gives you a way to further restrict the permissions for a
     *         federated user. You cannot use session policies to grant more permissions than those that are defined in
     *         the permissions policy of the IAM user. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
     *         Policies</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         <p>
     *         The plain text that you use for both inline and managed session policies shouldn't exceed 2048
     *         characters. The JSON policy characters can be any ASCII character from the space character to the end of
     *         the valid character list ( through \u00FF). It can also include the tab ( ), linefeed ( ), and carriage
     *         return ( ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The characters in this parameter count towards the 2048 character session policy guideline. However, an
     *         AWS conversion compresses the session policies into a packed binary format that has a separate limit.
     *         This is the enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage
     *         how close the policy is to the upper size limit.
     *         </p>
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session policy.
     * The policies must exist in the same account as the IAM user that is requesting federated access.
     * </p>
     * <p>
     * You must pass an inline or managed <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session policy</a>
     * to this operation. You can pass a single JSON policy document to use as an inline session policy. You can also
     * specify up to 10 managed policies to use as managed session policies. The plain text that you use for both inline
     * and managed session policies shouldn't exceed 2048 characters. You can provide up to 10 managed policy ARNs. For
     * more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a> in the AWS General Reference.
     * </p>
     * <p>
     * This parameter is optional. However, if you do not pass any session policies, then the resulting federated user
     * session has no permissions. The only exception is when the credentials are used to access a resource that has a
     * resource-based policy that specifically references the federated user session in the <code>Principal</code>
     * element of the policy.
     * </p>
     * <p>
     * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
     * session policies that you pass. This gives you a way to further restrict the permissions for a federated user.
     * You cannot use session policies to grant more permissions than those that are defined in the permissions policy
     * of the IAM user. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
     * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
     * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the policy
     * is to the upper size limit.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
     *         policy. The policies must exist in the same account as the IAM user that is requesting federated
     *         access.</p>
     *         <p>
     *         You must pass an inline or managed <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
     *         policy</a> to this operation. You can pass a single JSON policy document to use as an inline session
     *         policy. You can also specify up to 10 managed policies to use as managed session policies. The plain text
     *         that you use for both inline and managed session policies shouldn't exceed 2048 characters. You can
     *         provide up to 10 managed policy ARNs. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
     *         </p>
     *         <p>
     *         This parameter is optional. However, if you do not pass any session policies, then the resulting
     *         federated user session has no permissions. The only exception is when the credentials are used to access
     *         a resource that has a resource-based policy that specifically references the federated user session in
     *         the <code>Principal</code> element of the policy.
     *         </p>
     *         <p>
     *         When you pass session policies, the session permissions are the intersection of the IAM user policies and
     *         the session policies that you pass. This gives you a way to further restrict the permissions for a
     *         federated user. You cannot use session policies to grant more permissions than those that are defined in
     *         the permissions policy of the IAM user. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
     *         Policies</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The characters in this parameter count towards the 2048 character session policy guideline. However, an
     *         AWS conversion compresses the session policies into a packed binary format that has a separate limit.
     *         This is the enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage
     *         how close the policy is to the upper size limit.
     *         </p>
     */
    public List<PolicyDescriptorType> policyArns() {
        return policyArns;
    }

    /**
     * <p>
     * The duration, in seconds, that the session should last. Acceptable durations for federation sessions range from
     * 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the default. Sessions
     * obtained using AWS account root user credentials are restricted to a maximum of 3,600 seconds (one hour). If the
     * specified duration is longer than one hour, the session obtained by using root user credentials defaults to one
     * hour.
     * </p>
     * 
     * @return The duration, in seconds, that the session should last. Acceptable durations for federation sessions
     *         range from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the
     *         default. Sessions obtained using AWS account root user credentials are restricted to a maximum of 3,600
     *         seconds (one hour). If the specified duration is longer than one hour, the session obtained by using root
     *         user credentials defaults to one hour.
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(policyArns());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenRequest)) {
            return false;
        }
        GetFederationTokenRequest other = (GetFederationTokenRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(policy(), other.policy())
                && Objects.equals(policyArns(), other.policyArns()) && Objects.equals(durationSeconds(), other.durationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetFederationTokenRequest").add("Name", name()).add("Policy", policy())
                .add("PolicyArns", policyArns()).add("DurationSeconds", durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "PolicyArns":
            return Optional.ofNullable(clazz.cast(policyArns()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFederationTokenRequest, T> g) {
        return obj -> g.apply((GetFederationTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFederationTokenRequest> {
        /**
         * <p>
         * The name of the federated user. The name is used as an identifier for the temporary security credentials
         * (such as <code>Bob</code>). For example, you can reference the federated user name in a resource-based
         * policy, such as in an Amazon S3 bucket policy.
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@-
         * </p>
         * 
         * @param name
         *        The name of the federated user. The name is used as an identifier for the temporary security
         *        credentials (such as <code>Bob</code>). For example, you can reference the federated user name in a
         *        resource-based policy, such as in an Amazon S3 bucket policy.</p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An IAM policy in JSON format that you want to use as an inline session policy.
         * </p>
         * <p>
         * You must pass an inline or managed <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         * policy</a> to this operation. You can pass a single JSON policy document to use as an inline session policy.
         * You can also specify up to 10 managed policies to use as managed session policies.
         * </p>
         * <p>
         * This parameter is optional. However, if you do not pass any session policies, then the resulting federated
         * user session has no permissions. The only exception is when the credentials are used to access a resource
         * that has a resource-based policy that specifically references the federated user session in the
         * <code>Principal</code> element of the policy.
         * </p>
         * <p>
         * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
         * session policies that you pass. This gives you a way to further restrict the permissions for a federated
         * user. You cannot use session policies to grant more permissions than those that are defined in the
         * permissions policy of the IAM user. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         * Policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * The plain text that you use for both inline and managed session policies shouldn't exceed 2048 characters.
         * The JSON policy characters can be any ASCII character from the space character to the end of the valid
         * character list ( through \u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
         * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
         * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the
         * policy is to the upper size limit.
         * </p>
         * </note>
         * 
         * @param policy
         *        An IAM policy in JSON format that you want to use as an inline session policy.</p>
         *        <p>
         *        You must pass an inline or managed <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         *        policy</a> to this operation. You can pass a single JSON policy document to use as an inline session
         *        policy. You can also specify up to 10 managed policies to use as managed session policies.
         *        </p>
         *        <p>
         *        This parameter is optional. However, if you do not pass any session policies, then the resulting
         *        federated user session has no permissions. The only exception is when the credentials are used to
         *        access a resource that has a resource-based policy that specifically references the federated user
         *        session in the <code>Principal</code> element of the policy.
         *        </p>
         *        <p>
         *        When you pass session policies, the session permissions are the intersection of the IAM user policies
         *        and the session policies that you pass. This gives you a way to further restrict the permissions for a
         *        federated user. You cannot use session policies to grant more permissions than those that are defined
         *        in the permissions policy of the IAM user. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         *        Policies</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        <p>
         *        The plain text that you use for both inline and managed session policies shouldn't exceed 2048
         *        characters. The JSON policy characters can be any ASCII character from the space character to the end
         *        of the valid character list ( through \u00FF). It can also include the tab ( ), linefeed ( ), and
         *        carriage return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The characters in this parameter count towards the 2048 character session policy guideline. However,
         *        an AWS conversion compresses the session policies into a packed binary format that has a separate
         *        limit. This is the enforced limit. The <code>PackedPolicySize</code> response element indicates by
         *        percentage how close the policy is to the upper size limit.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
         * policy. The policies must exist in the same account as the IAM user that is requesting federated access.
         * </p>
         * <p>
         * You must pass an inline or managed <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         * policy</a> to this operation. You can pass a single JSON policy document to use as an inline session policy.
         * You can also specify up to 10 managed policies to use as managed session policies. The plain text that you
         * use for both inline and managed session policies shouldn't exceed 2048 characters. You can provide up to 10
         * managed policy ARNs. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
         * </p>
         * <p>
         * This parameter is optional. However, if you do not pass any session policies, then the resulting federated
         * user session has no permissions. The only exception is when the credentials are used to access a resource
         * that has a resource-based policy that specifically references the federated user session in the
         * <code>Principal</code> element of the policy.
         * </p>
         * <p>
         * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
         * session policies that you pass. This gives you a way to further restrict the permissions for a federated
         * user. You cannot use session policies to grant more permissions than those that are defined in the
         * permissions policy of the IAM user. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         * Policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
         * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
         * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the
         * policy is to the upper size limit.
         * </p>
         * </note>
         * 
         * @param policyArns
         *        The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
         *        policy. The policies must exist in the same account as the IAM user that is requesting federated
         *        access.</p>
         *        <p>
         *        You must pass an inline or managed <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         *        policy</a> to this operation. You can pass a single JSON policy document to use as an inline session
         *        policy. You can also specify up to 10 managed policies to use as managed session policies. The plain
         *        text that you use for both inline and managed session policies shouldn't exceed 2048 characters. You
         *        can provide up to 10 managed policy ARNs. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
         *        </p>
         *        <p>
         *        This parameter is optional. However, if you do not pass any session policies, then the resulting
         *        federated user session has no permissions. The only exception is when the credentials are used to
         *        access a resource that has a resource-based policy that specifically references the federated user
         *        session in the <code>Principal</code> element of the policy.
         *        </p>
         *        <p>
         *        When you pass session policies, the session permissions are the intersection of the IAM user policies
         *        and the session policies that you pass. This gives you a way to further restrict the permissions for a
         *        federated user. You cannot use session policies to grant more permissions than those that are defined
         *        in the permissions policy of the IAM user. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         *        Policies</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The characters in this parameter count towards the 2048 character session policy guideline. However,
         *        an AWS conversion compresses the session policies into a packed binary format that has a separate
         *        limit. This is the enforced limit. The <code>PackedPolicySize</code> response element indicates by
         *        percentage how close the policy is to the upper size limit.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArns(Collection<PolicyDescriptorType> policyArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
         * policy. The policies must exist in the same account as the IAM user that is requesting federated access.
         * </p>
         * <p>
         * You must pass an inline or managed <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         * policy</a> to this operation. You can pass a single JSON policy document to use as an inline session policy.
         * You can also specify up to 10 managed policies to use as managed session policies. The plain text that you
         * use for both inline and managed session policies shouldn't exceed 2048 characters. You can provide up to 10
         * managed policy ARNs. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
         * </p>
         * <p>
         * This parameter is optional. However, if you do not pass any session policies, then the resulting federated
         * user session has no permissions. The only exception is when the credentials are used to access a resource
         * that has a resource-based policy that specifically references the federated user session in the
         * <code>Principal</code> element of the policy.
         * </p>
         * <p>
         * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
         * session policies that you pass. This gives you a way to further restrict the permissions for a federated
         * user. You cannot use session policies to grant more permissions than those that are defined in the
         * permissions policy of the IAM user. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         * Policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
         * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
         * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the
         * policy is to the upper size limit.
         * </p>
         * </note>
         * 
         * @param policyArns
         *        The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
         *        policy. The policies must exist in the same account as the IAM user that is requesting federated
         *        access.</p>
         *        <p>
         *        You must pass an inline or managed <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         *        policy</a> to this operation. You can pass a single JSON policy document to use as an inline session
         *        policy. You can also specify up to 10 managed policies to use as managed session policies. The plain
         *        text that you use for both inline and managed session policies shouldn't exceed 2048 characters. You
         *        can provide up to 10 managed policy ARNs. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
         *        </p>
         *        <p>
         *        This parameter is optional. However, if you do not pass any session policies, then the resulting
         *        federated user session has no permissions. The only exception is when the credentials are used to
         *        access a resource that has a resource-based policy that specifically references the federated user
         *        session in the <code>Principal</code> element of the policy.
         *        </p>
         *        <p>
         *        When you pass session policies, the session permissions are the intersection of the IAM user policies
         *        and the session policies that you pass. This gives you a way to further restrict the permissions for a
         *        federated user. You cannot use session policies to grant more permissions than those that are defined
         *        in the permissions policy of the IAM user. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         *        Policies</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The characters in this parameter count towards the 2048 character session policy guideline. However,
         *        an AWS conversion compresses the session policies into a packed binary format that has a separate
         *        limit. This is the enforced limit. The <code>PackedPolicySize</code> response element indicates by
         *        percentage how close the policy is to the upper size limit.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArns(PolicyDescriptorType... policyArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the IAM managed policies that you want to use as a managed session
         * policy. The policies must exist in the same account as the IAM user that is requesting federated access.
         * </p>
         * <p>
         * You must pass an inline or managed <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">session
         * policy</a> to this operation. You can pass a single JSON policy document to use as an inline session policy.
         * You can also specify up to 10 managed policies to use as managed session policies. The plain text that you
         * use for both inline and managed session policies shouldn't exceed 2048 characters. You can provide up to 10
         * managed policy ARNs. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the AWS General Reference.
         * </p>
         * <p>
         * This parameter is optional. However, if you do not pass any session policies, then the resulting federated
         * user session has no permissions. The only exception is when the credentials are used to access a resource
         * that has a resource-based policy that specifically references the federated user session in the
         * <code>Principal</code> element of the policy.
         * </p>
         * <p>
         * When you pass session policies, the session permissions are the intersection of the IAM user policies and the
         * session policies that you pass. This gives you a way to further restrict the permissions for a federated
         * user. You cannot use session policies to grant more permissions than those that are defined in the
         * permissions policy of the IAM user. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session">Session
         * Policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The characters in this parameter count towards the 2048 character session policy guideline. However, an AWS
         * conversion compresses the session policies into a packed binary format that has a separate limit. This is the
         * enforced limit. The <code>PackedPolicySize</code> response element indicates by percentage how close the
         * policy is to the upper size limit.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<PolicyDescriptorType>.Builder}
         * avoiding the need to create one manually via {@link List<PolicyDescriptorType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyDescriptorType>.Builder#build()} is called immediately
         * and its result is passed to {@link #policyArns(List<PolicyDescriptorType>)}.
         * 
         * @param policyArns
         *        a consumer that will call methods on {@link List<PolicyDescriptorType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyArns(List<PolicyDescriptorType>)
         */
        Builder policyArns(Consumer<PolicyDescriptorType.Builder>... policyArns);

        /**
         * <p>
         * The duration, in seconds, that the session should last. Acceptable durations for federation sessions range
         * from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the default.
         * Sessions obtained using AWS account root user credentials are restricted to a maximum of 3,600 seconds (one
         * hour). If the specified duration is longer than one hour, the session obtained by using root user credentials
         * defaults to one hour.
         * </p>
         * 
         * @param durationSeconds
         *        The duration, in seconds, that the session should last. Acceptable durations for federation sessions
         *        range from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as
         *        the default. Sessions obtained using AWS account root user credentials are restricted to a maximum of
         *        3,600 seconds (one hour). If the specified duration is longer than one hour, the session obtained by
         *        using root user credentials defaults to one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String name;

        private String policy;

        private List<PolicyDescriptorType> policyArns = DefaultSdkAutoConstructList.getInstance();

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenRequest model) {
            super(model);
            name(model.name);
            policy(model.policy);
            policyArns(model.policyArns);
            durationSeconds(model.durationSeconds);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Collection<PolicyDescriptorType.Builder> getPolicyArns() {
            return policyArns != null ? policyArns.stream().map(PolicyDescriptorType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder policyArns(Collection<PolicyDescriptorType> policyArns) {
            this.policyArns = _policyDescriptorListTypeCopier.copy(policyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyArns(PolicyDescriptorType... policyArns) {
            policyArns(Arrays.asList(policyArns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyArns(Consumer<PolicyDescriptorType.Builder>... policyArns) {
            policyArns(Stream.of(policyArns).map(c -> PolicyDescriptorType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyArns(Collection<PolicyDescriptorType.BuilderImpl> policyArns) {
            this.policyArns = _policyDescriptorListTypeCopier.copyFromBuilder(policyArns);
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFederationTokenRequest build() {
            return new GetFederationTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
