/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenCredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public final class StsWebIdentityCredentialsProviderFactory
implements WebIdentityTokenCredentialsProviderFactory {
    public AwsCredentialsProvider create(WebIdentityTokenCredentialProperties credentialProperties) {
        return new StsWebIdentityCredentialsProvider(credentialProperties);
    }

    private static final class StsRetryCondition
    implements RetryCondition {
        private StsRetryCondition() {
        }

        public boolean shouldRetry(RetryPolicyContext context) {
            return context.exception() instanceof IdpCommunicationErrorException;
        }
    }

    private static final class AssumeRoleWithWebIdentityRequestSupplier
    implements Supplier {
        private final AssumeRoleWithWebIdentityRequest request;
        private final Path webIdentityTokenFile;

        AssumeRoleWithWebIdentityRequestSupplier(AssumeRoleWithWebIdentityRequest request, Path webIdentityTokenFile) {
            this.request = request;
            this.webIdentityTokenFile = webIdentityTokenFile;
        }

        public Object get() {
            return this.request.toBuilder().webIdentityToken(this.getToken(this.webIdentityTokenFile)).build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getToken(Path file) {
            try (InputStream webIdentityTokenStream = Files.newInputStream(file, new OpenOption[0]);){
                String string = IoUtils.toUtf8String((InputStream)webIdentityTokenStream);
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static final class StsWebIdentityCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final StsClient stsClient;
        private final StsAssumeRoleWithWebIdentityCredentialsProvider credentialsProvider;

        private StsWebIdentityCredentialsProvider(WebIdentityTokenCredentialProperties credentialProperties) {
            String roleSessionName = credentialProperties.roleSessionName();
            String sessionName = roleSessionName != null ? roleSessionName : "aws-sdk-java-" + System.currentTimeMillis();
            OrRetryCondition retryCondition = OrRetryCondition.create((RetryCondition[])new RetryCondition[]{new StsRetryCondition(), RetryCondition.defaultRetryCondition()});
            this.stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().applyMutation(this::configureEndpoint)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).overrideConfiguration(o -> o.retryPolicy(r -> r.retryCondition((RetryCondition)retryCondition)))).build();
            AssumeRoleWithWebIdentityRequest request = (AssumeRoleWithWebIdentityRequest)((Object)AssumeRoleWithWebIdentityRequest.builder().roleArn(credentialProperties.roleArn()).roleSessionName(sessionName).build());
            AssumeRoleWithWebIdentityRequestSupplier supplier = new AssumeRoleWithWebIdentityRequestSupplier(request, credentialProperties.webIdentityTokenFile());
            this.credentialsProvider = (StsAssumeRoleWithWebIdentityCredentialsProvider)((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(this.stsClient)).refreshRequest(supplier).build();
        }

        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.credentialsProvider), null);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.stsClient), null);
        }

        private void configureEndpoint(StsClientBuilder stsClientBuilder) {
            Region stsRegion;
            try {
                stsRegion = new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (RuntimeException e) {
                stsRegion = null;
            }
            if (stsRegion != null) {
                stsClientBuilder.region(stsRegion);
            } else {
                stsClientBuilder.region(Region.US_EAST_1);
                stsClientBuilder.endpointOverride(URI.create("https://sts.amazonaws.com"));
            }
        }
    }
}

