/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.SupplyChainServiceClientConfiguration;
import software.amazon.awssdk.services.supplychain.internal.SupplyChainServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.supplychain.model.AccessDeniedException;
import software.amazon.awssdk.services.supplychain.model.ConflictException;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.InternalServerException;
import software.amazon.awssdk.services.supplychain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supplychain.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supplychain.model.SupplyChainException;
import software.amazon.awssdk.services.supplychain.model.ThrottlingException;
import software.amazon.awssdk.services.supplychain.model.ValidationException;
import software.amazon.awssdk.services.supplychain.transform.CreateBillOfMaterialsImportJobRequestMarshaller;
import software.amazon.awssdk.services.supplychain.transform.GetBillOfMaterialsImportJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSupplyChainClient
implements SupplyChainClient {
    private static final Logger log = Logger.loggerFor(DefaultSupplyChainClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSupplyChainClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBillOfMaterialsImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBillOfMaterialsImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupplyChainClient.resolveMetricPublishers(clientConfiguration, createBillOfMaterialsImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SupplyChain");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBillOfMaterialsImportJob");
            CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJobResponse = (CreateBillOfMaterialsImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBillOfMaterialsImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBillOfMaterialsImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBillOfMaterialsImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBillOfMaterialsImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupplyChainClient.lambda$createBillOfMaterialsImportJob$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBillOfMaterialsImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBillOfMaterialsImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupplyChainClient.resolveMetricPublishers(clientConfiguration, getBillOfMaterialsImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SupplyChain");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBillOfMaterialsImportJob");
            GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJobResponse = (GetBillOfMaterialsImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBillOfMaterialsImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBillOfMaterialsImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBillOfMaterialsImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBillOfMaterialsImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupplyChainClient.lambda$getBillOfMaterialsImportJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "scn";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SupplyChainServiceClientConfigurationBuilder serviceConfigBuilder = new SupplyChainServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SupplyChainException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build());
    }

    @Override
    public final SupplyChainServiceClientConfiguration serviceClientConfiguration() {
        return new SupplyChainServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$getBillOfMaterialsImportJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBillOfMaterialsImportJob$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

