/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.supplychain.model.AccessDeniedException;
import software.amazon.awssdk.services.supplychain.model.ConflictException;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.InternalServerException;
import software.amazon.awssdk.services.supplychain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supplychain.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supplychain.model.SupplyChainException;
import software.amazon.awssdk.services.supplychain.model.ThrottlingException;
import software.amazon.awssdk.services.supplychain.model.ValidationException;

/**
 * Service client for accessing AWS Supply Chain. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Supply Chain is a cloud-based application that works with your enterprise resource planning (ERP) and supply
 * chain management systems. Using AWS Supply Chain, you can connect and extract your inventory, supply, and demand
 * related data from existing ERP or supply chain systems into a single data model.
 * </p>
 * <p>
 * The AWS Supply Chain API supports configuration data import for Supply Planning.
 * </p>
 * <p>
 * All AWS Supply chain API operations are Amazon-authenticated and certificate-signed. They not only require the use of
 * the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help
 * facilitate access, trust, and permission policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupplyChainClient extends AwsClient {
    String SERVICE_NAME = "scn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "scn";

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            Consumer<CreateBillOfMaterialsImportJobRequest.Builder> createBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest.builder()
                .applyMutation(createBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            Consumer<GetBillOfMaterialsImportJobRequest.Builder> getBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest.builder()
                .applyMutation(getBillOfMaterialsImportJobRequest).build());
    }

    /**
     * Create a {@link SupplyChainClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupplyChainClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupplyChainClient}.
     */
    static SupplyChainClientBuilder builder() {
        return new DefaultSupplyChainClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SupplyChainServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
