/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DataIntegrationEventType {
    SCN_DATA_FORECAST("scn.data.forecast"),

    SCN_DATA_INVENTORYLEVEL("scn.data.inventorylevel"),

    SCN_DATA_INBOUNDORDER("scn.data.inboundorder"),

    SCN_DATA_INBOUNDORDERLINE("scn.data.inboundorderline"),

    SCN_DATA_INBOUNDORDERLINESCHEDULE("scn.data.inboundorderlineschedule"),

    SCN_DATA_OUTBOUNDORDERLINE("scn.data.outboundorderline"),

    SCN_DATA_OUTBOUNDSHIPMENT("scn.data.outboundshipment"),

    SCN_DATA_PROCESSHEADER("scn.data.processheader"),

    SCN_DATA_PROCESSOPERATION("scn.data.processoperation"),

    SCN_DATA_PROCESSPRODUCT("scn.data.processproduct"),

    SCN_DATA_RESERVATION("scn.data.reservation"),

    SCN_DATA_SHIPMENT("scn.data.shipment"),

    SCN_DATA_SHIPMENTSTOP("scn.data.shipmentstop"),

    SCN_DATA_SHIPMENTSTOPORDER("scn.data.shipmentstoporder"),

    SCN_DATA_SUPPLYPLAN("scn.data.supplyplan"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataIntegrationEventType> VALUE_MAP = EnumUtils.uniqueIndex(DataIntegrationEventType.class,
            DataIntegrationEventType::toString);

    private final String value;

    private DataIntegrationEventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DataIntegrationEventType corresponding to the value
     */
    public static DataIntegrationEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DataIntegrationEventType}s
     */
    public static Set<DataIntegrationEventType> knownValues() {
        Set<DataIntegrationEventType> knownValues = EnumSet.allOf(DataIntegrationEventType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
