/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.supplychain.model.AccessDeniedException;
import software.amazon.awssdk.services.supplychain.model.ConflictException;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.InternalServerException;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.supplychain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventResponse;
import software.amazon.awssdk.services.supplychain.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supplychain.model.SupplyChainException;
import software.amazon.awssdk.services.supplychain.model.TagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.TagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.ThrottlingException;
import software.amazon.awssdk.services.supplychain.model.UntagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.UntagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.ValidationException;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable;

/**
 * Service client for accessing AWS Supply Chain. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Supply Chain is a cloud-based application that works with your enterprise resource planning (ERP) and supply
 * chain management systems. Using AWS Supply Chain, you can connect and extract your inventory, supply, and demand
 * related data from existing ERP or supply chain systems into a single data model.
 * </p>
 * <p>
 * The AWS Supply Chain API supports configuration data import for Supply Planning.
 * </p>
 * <p>
 * All AWS Supply chain API operations are Amazon-authenticated and certificate-signed. They not only require the use of
 * the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help
 * facilitate access, trust, and permission policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupplyChainClient extends AwsClient {
    String SERVICE_NAME = "scn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "scn";

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            Consumer<CreateBillOfMaterialsImportJobRequest.Builder> createBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest.builder()
                .applyMutation(createBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Create DataIntegrationFlow to map one or more different sources to one target using the SQL transformation query.
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        The request parameters for CreateDataIntegrationFlow.
     * @return Result of the CreateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationFlowResponse createDataIntegrationFlow(
            CreateDataIntegrationFlowRequest createDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create DataIntegrationFlow to map one or more different sources to one target using the SQL transformation query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for CreateDataIntegrationFlow.
     * @return Result of the CreateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationFlowResponse createDataIntegrationFlow(
            Consumer<CreateDataIntegrationFlowRequest.Builder> createDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createDataIntegrationFlow(CreateDataIntegrationFlowRequest.builder()
                .applyMutation(createDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Create a data lake dataset.
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        The request parameters for CreateDataLakeDataset.
     * @return Result of the CreateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeDatasetResponse createDataLakeDataset(CreateDataLakeDatasetRequest createDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a data lake dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for CreateDataLakeDataset.
     * @return Result of the CreateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeDatasetResponse createDataLakeDataset(
            Consumer<CreateDataLakeDatasetRequest.Builder> createDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return createDataLakeDataset(CreateDataLakeDatasetRequest.builder().applyMutation(createDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Delete the DataIntegrationFlow.
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        The request parameters for DeleteDataIntegrationFlow.
     * @return Result of the DeleteDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationFlowResponse deleteDataIntegrationFlow(
            DeleteDataIntegrationFlowRequest deleteDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the DataIntegrationFlow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for DeleteDataIntegrationFlow.
     * @return Result of the DeleteDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationFlowResponse deleteDataIntegrationFlow(
            Consumer<DeleteDataIntegrationFlowRequest.Builder> deleteDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return deleteDataIntegrationFlow(DeleteDataIntegrationFlowRequest.builder()
                .applyMutation(deleteDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Delete a data lake dataset.
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        The request parameters of DeleteDataLakeDataset.
     * @return Result of the DeleteDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeDatasetResponse deleteDataLakeDataset(DeleteDataLakeDatasetRequest deleteDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a data lake dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of DeleteDataLakeDataset.
     * @return Result of the DeleteDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeDatasetResponse deleteDataLakeDataset(
            Consumer<DeleteDataLakeDatasetRequest.Builder> deleteDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return deleteDataLakeDataset(DeleteDataLakeDatasetRequest.builder().applyMutation(deleteDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            Consumer<GetBillOfMaterialsImportJobRequest.Builder> getBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest.builder()
                .applyMutation(getBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * View the DataIntegrationFlow details.
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        The request parameters for GetDataIntegrationFlow.
     * @return Result of the GetDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowResponse getDataIntegrationFlow(GetDataIntegrationFlowRequest getDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View the DataIntegrationFlow details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationFlowRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest.Builder} to create
     *        a request. The request parameters for GetDataIntegrationFlow.
     * @return Result of the GetDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowResponse getDataIntegrationFlow(
            Consumer<GetDataIntegrationFlowRequest.Builder> getDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return getDataIntegrationFlow(GetDataIntegrationFlowRequest.builder().applyMutation(getDataIntegrationFlowRequest)
                .build());
    }

    /**
     * <p>
     * Get a data lake dataset.
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        The request parameters for GetDataLakeDataset.
     * @return Result of the GetDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeDatasetResponse getDataLakeDataset(GetDataLakeDatasetRequest getDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a data lake dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for GetDataLakeDataset.
     * @return Result of the GetDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeDatasetResponse getDataLakeDataset(Consumer<GetDataLakeDatasetRequest.Builder> getDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getDataLakeDataset(GetDataLakeDatasetRequest.builder().applyMutation(getDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Lists all the DataIntegrationFlows in a paginated way.
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return Result of the ListDataIntegrationFlows operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsResponse listDataIntegrationFlows(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the DataIntegrationFlows in a paginated way.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return Result of the ListDataIntegrationFlows operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsResponse listDataIntegrationFlows(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlows(ListDataIntegrationFlowsRequest.builder().applyMutation(listDataIntegrationFlowsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client
     *             .listDataIntegrationFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsIterable listDataIntegrationFlowsPaginator(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return new ListDataIntegrationFlowsIterable(this, listDataIntegrationFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client
     *             .listDataIntegrationFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsIterable listDataIntegrationFlowsPaginator(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlowsPaginator(ListDataIntegrationFlowsRequest.builder()
                .applyMutation(listDataIntegrationFlowsRequest).build());
    }

    /**
     * <p>
     * List the data lake datasets for a specific instance and name space.
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return Result of the ListDataLakeDatasets operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsResponse listDataLakeDatasets(ListDataLakeDatasetsRequest listDataLakeDatasetsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the data lake datasets for a specific instance and name space.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return Result of the ListDataLakeDatasets operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsResponse listDataLakeDatasets(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeDatasets(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client
     *             .listDataLakeDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsIterable listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest listDataLakeDatasetsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return new ListDataLakeDatasetsIterable(this, listDataLakeDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client
     *             .listDataLakeDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsIterable listDataLakeDatasetsPaginator(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request parameters of ListTagsForResource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest.Builder} to create a
     *        request. The request parameters of ListTagsForResource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Send the transactional data payload for the event with real-time data for analysis or monitoring. The real-time
     * data events are stored in an Amazon Web Services service before being processed and stored in data lake. New data
     * events are synced with data lake at 5 PM GMT everyday. The updated transactional data is available in data lake
     * after ingestion.
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        The request parameters for SendDataIntegrationEvent.
     * @return Result of the SendDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataIntegrationEventResponse sendDataIntegrationEvent(
            SendDataIntegrationEventRequest sendDataIntegrationEventRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send the transactional data payload for the event with real-time data for analysis or monitoring. The real-time
     * data events are stored in an Amazon Web Services service before being processed and stored in data lake. New data
     * events are synced with data lake at 5 PM GMT everyday. The updated transactional data is available in data lake
     * after ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataIntegrationEventRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataIntegrationEventRequest#builder()}
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest.Builder} to
     *        create a request. The request parameters for SendDataIntegrationEvent.
     * @return Result of the SendDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataIntegrationEventResponse sendDataIntegrationEvent(
            Consumer<SendDataIntegrationEventRequest.Builder> sendDataIntegrationEventRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return sendDataIntegrationEvent(SendDataIntegrationEventRequest.builder().applyMutation(sendDataIntegrationEventRequest)
                .build());
    }

    /**
     * <p>
     * Create tags for an Amazon Web Services Supply chain resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request parameters of TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create tags for an Amazon Web Services Supply chain resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.TagResourceRequest.Builder} to create a request.
     *        The request parameters of TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Delete tags for an Amazon Web Services Supply chain resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request parameters of UntagResource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete tags for an Amazon Web Services Supply chain resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UntagResourceRequest.Builder} to create a
     *        request. The request parameters of UntagResource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the DataIntegrationFlow.
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        The request parameters for UpdateDataIntegrationFlow.
     * @return Result of the UpdateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationFlowResponse updateDataIntegrationFlow(
            UpdateDataIntegrationFlowRequest updateDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the DataIntegrationFlow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for UpdateDataIntegrationFlow.
     * @return Result of the UpdateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationFlowResponse updateDataIntegrationFlow(
            Consumer<UpdateDataIntegrationFlowRequest.Builder> updateDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return updateDataIntegrationFlow(UpdateDataIntegrationFlowRequest.builder()
                .applyMutation(updateDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Update a data lake dataset.
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        The request parameters of UpdateDataLakeDataset.
     * @return Result of the UpdateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeDatasetResponse updateDataLakeDataset(UpdateDataLakeDatasetRequest updateDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a data lake dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of UpdateDataLakeDataset.
     * @return Result of the UpdateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeDatasetResponse updateDataLakeDataset(
            Consumer<UpdateDataLakeDatasetRequest.Builder> updateDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return updateDataLakeDataset(UpdateDataLakeDatasetRequest.builder().applyMutation(updateDataLakeDatasetRequest).build());
    }

    /**
     * Create a {@link SupplyChainClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupplyChainClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupplyChainClient}.
     */
    static SupplyChainClientBuilder builder() {
        return new DefaultSupplyChainClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SupplyChainServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
