/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for ListInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesRequest extends SupplyChainRequest implements
        ToCopyableBuilder<ListInstancesRequest.Builder, ListInstancesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> INSTANCE_NAME_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceNameFilter")
            .getter(getter(ListInstancesRequest::instanceNameFilter))
            .setter(setter(Builder::instanceNameFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceNameFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCE_STATE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceStateFilter")
            .getter(getter(ListInstancesRequest::instanceStateFilterAsStrings))
            .setter(setter(Builder::instanceStateFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceStateFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INSTANCE_NAME_FILTER_FIELD, INSTANCE_STATE_FILTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> instanceNameFilter;

    private final List<String> instanceStateFilter;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.instanceNameFilter = builder.instanceNameFilter;
        this.instanceStateFilter = builder.instanceStateFilter;
    }

    /**
     * <p>
     * The pagination token to fetch the next page of instances.
     * </p>
     * 
     * @return The pagination token to fetch the next page of instances.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify the maximum number of instances to fetch in this paginated request.
     * </p>
     * 
     * @return Specify the maximum number of instances to fetch in this paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceNameFilter property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceNameFilter() {
        return instanceNameFilter != null && !(instanceNameFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to ListInstances based on their names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceNameFilter} method.
     * </p>
     * 
     * @return The filter to ListInstances based on their names.
     */
    public final List<String> instanceNameFilter() {
        return instanceNameFilter;
    }

    /**
     * <p>
     * The filter to ListInstances based on their state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStateFilter} method.
     * </p>
     * 
     * @return The filter to ListInstances based on their state.
     */
    public final List<InstanceState> instanceStateFilter() {
        return InstanceStateListCopier.copyStringToEnum(instanceStateFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStateFilter property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceStateFilter() {
        return instanceStateFilter != null && !(instanceStateFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to ListInstances based on their state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStateFilter} method.
     * </p>
     * 
     * @return The filter to ListInstances based on their state.
     */
    public final List<String> instanceStateFilterAsStrings() {
        return instanceStateFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceNameFilter() ? instanceNameFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStateFilter() ? instanceStateFilterAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasInstanceNameFilter() == other.hasInstanceNameFilter()
                && Objects.equals(instanceNameFilter(), other.instanceNameFilter())
                && hasInstanceStateFilter() == other.hasInstanceStateFilter()
                && Objects.equals(instanceStateFilterAsStrings(), other.instanceStateFilterAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstancesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("InstanceNameFilter", hasInstanceNameFilter() ? instanceNameFilter() : null)
                .add("InstanceStateFilter", hasInstanceStateFilter() ? instanceStateFilterAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "instanceNameFilter":
            return Optional.ofNullable(clazz.cast(instanceNameFilter()));
        case "instanceStateFilter":
            return Optional.ofNullable(clazz.cast(instanceStateFilterAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesRequest, T> g) {
        return obj -> g.apply((ListInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInstancesRequest> {
        /**
         * <p>
         * The pagination token to fetch the next page of instances.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to fetch the next page of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify the maximum number of instances to fetch in this paginated request.
         * </p>
         * 
         * @param maxResults
         *        Specify the maximum number of instances to fetch in this paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The filter to ListInstances based on their names.
         * </p>
         * 
         * @param instanceNameFilter
         *        The filter to ListInstances based on their names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNameFilter(Collection<String> instanceNameFilter);

        /**
         * <p>
         * The filter to ListInstances based on their names.
         * </p>
         * 
         * @param instanceNameFilter
         *        The filter to ListInstances based on their names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNameFilter(String... instanceNameFilter);

        /**
         * <p>
         * The filter to ListInstances based on their state.
         * </p>
         * 
         * @param instanceStateFilter
         *        The filter to ListInstances based on their state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStateFilterWithStrings(Collection<String> instanceStateFilter);

        /**
         * <p>
         * The filter to ListInstances based on their state.
         * </p>
         * 
         * @param instanceStateFilter
         *        The filter to ListInstances based on their state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStateFilterWithStrings(String... instanceStateFilter);

        /**
         * <p>
         * The filter to ListInstances based on their state.
         * </p>
         * 
         * @param instanceStateFilter
         *        The filter to ListInstances based on their state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStateFilter(Collection<InstanceState> instanceStateFilter);

        /**
         * <p>
         * The filter to ListInstances based on their state.
         * </p>
         * 
         * @param instanceStateFilter
         *        The filter to ListInstances based on their state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStateFilter(InstanceState... instanceStateFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> instanceNameFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> instanceStateFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            instanceNameFilter(model.instanceNameFilter);
            instanceStateFilterWithStrings(model.instanceStateFilter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getInstanceNameFilter() {
            if (instanceNameFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceNameFilter;
        }

        public final void setInstanceNameFilter(Collection<String> instanceNameFilter) {
            this.instanceNameFilter = InstanceNameListCopier.copy(instanceNameFilter);
        }

        @Override
        public final Builder instanceNameFilter(Collection<String> instanceNameFilter) {
            this.instanceNameFilter = InstanceNameListCopier.copy(instanceNameFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNameFilter(String... instanceNameFilter) {
            instanceNameFilter(Arrays.asList(instanceNameFilter));
            return this;
        }

        public final Collection<String> getInstanceStateFilter() {
            if (instanceStateFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceStateFilter;
        }

        public final void setInstanceStateFilter(Collection<String> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copy(instanceStateFilter);
        }

        @Override
        public final Builder instanceStateFilterWithStrings(Collection<String> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copy(instanceStateFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStateFilterWithStrings(String... instanceStateFilter) {
            instanceStateFilterWithStrings(Arrays.asList(instanceStateFilter));
            return this;
        }

        @Override
        public final Builder instanceStateFilter(Collection<InstanceState> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copyEnumToString(instanceStateFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStateFilter(InstanceState... instanceStateFilter) {
            instanceStateFilter(Arrays.asList(instanceStateFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
