/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for CreateBillOfMaterialsImportJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBillOfMaterialsImportJobRequest extends SupplyChainRequest implements
        ToCopyableBuilder<CreateBillOfMaterialsImportJobRequest.Builder, CreateBillOfMaterialsImportJobRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(CreateBillOfMaterialsImportJobRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3uri")
            .getter(getter(CreateBillOfMaterialsImportJobRequest::s3uri)).setter(setter(Builder::s3uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3uri").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateBillOfMaterialsImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            S3_URI_FIELD, CLIENT_TOKEN_FIELD));

    private final String instanceId;

    private final String s3uri;

    private final String clientToken;

    private CreateBillOfMaterialsImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.s3uri = builder.s3uri;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The AWS Supply Chain instance identifier.
     * </p>
     * 
     * @return The AWS Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The S3 URI of the CSV file to be imported. The bucket must grant permissions for AWS Supply Chain to read the
     * file.
     * </p>
     * 
     * @return The S3 URI of the CSV file to be imported. The bucket must grant permissions for AWS Supply Chain to read
     *         the file.
     */
    public final String s3uri() {
        return s3uri;
    }

    /**
     * <p>
     * An idempotency token ensures the API request is only completed no more than once. This way, retrying the request
     * will not trigger the operation multiple times. A client token is a unique, case-sensitive string of 33 to 128
     * ASCII characters. To make an idempotent API request, specify a client token in the request. You should not reuse
     * the same client token for other requests. If you retry a successful request with the same client token, the
     * request will succeed with no further actions being taken, and you will receive the same API response as the
     * original successful request.
     * </p>
     * 
     * @return An idempotency token ensures the API request is only completed no more than once. This way, retrying the
     *         request will not trigger the operation multiple times. A client token is a unique, case-sensitive string
     *         of 33 to 128 ASCII characters. To make an idempotent API request, specify a client token in the request.
     *         You should not reuse the same client token for other requests. If you retry a successful request with the
     *         same client token, the request will succeed with no further actions being taken, and you will receive the
     *         same API response as the original successful request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(s3uri());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillOfMaterialsImportJobRequest)) {
            return false;
        }
        CreateBillOfMaterialsImportJobRequest other = (CreateBillOfMaterialsImportJobRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(s3uri(), other.s3uri())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBillOfMaterialsImportJobRequest").add("InstanceId", instanceId()).add("S3uri", s3uri())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "s3uri":
            return Optional.ofNullable(clazz.cast(s3uri()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBillOfMaterialsImportJobRequest, T> g) {
        return obj -> g.apply((CreateBillOfMaterialsImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBillOfMaterialsImportJobRequest> {
        /**
         * <p>
         * The AWS Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The AWS Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The S3 URI of the CSV file to be imported. The bucket must grant permissions for AWS Supply Chain to read the
         * file.
         * </p>
         * 
         * @param s3uri
         *        The S3 URI of the CSV file to be imported. The bucket must grant permissions for AWS Supply Chain to
         *        read the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3uri(String s3uri);

        /**
         * <p>
         * An idempotency token ensures the API request is only completed no more than once. This way, retrying the
         * request will not trigger the operation multiple times. A client token is a unique, case-sensitive string of
         * 33 to 128 ASCII characters. To make an idempotent API request, specify a client token in the request. You
         * should not reuse the same client token for other requests. If you retry a successful request with the same
         * client token, the request will succeed with no further actions being taken, and you will receive the same API
         * response as the original successful request.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token ensures the API request is only completed no more than once. This way, retrying
         *        the request will not trigger the operation multiple times. A client token is a unique, case-sensitive
         *        string of 33 to 128 ASCII characters. To make an idempotent API request, specify a client token in the
         *        request. You should not reuse the same client token for other requests. If you retry a successful
         *        request with the same client token, the request will succeed with no further actions being taken, and
         *        you will receive the same API response as the original successful request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String s3uri;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillOfMaterialsImportJobRequest model) {
            super(model);
            instanceId(model.instanceId);
            s3uri(model.s3uri);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getS3uri() {
            return s3uri;
        }

        public final void setS3uri(String s3uri) {
            this.s3uri = s3uri;
        }

        @Override
        public final Builder s3uri(String s3uri) {
            this.s3uri = s3uri;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillOfMaterialsImportJobRequest build() {
            return new CreateBillOfMaterialsImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
