/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset field details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeDatasetSchemaField implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeDatasetSchemaField.Builder, DataLakeDatasetSchemaField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataLakeDatasetSchemaField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataLakeDatasetSchemaField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRequired").getter(getter(DataLakeDatasetSchemaField::isRequired)).setter(setter(Builder::isRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            IS_REQUIRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final Boolean isRequired;

    private DataLakeDatasetSchemaField(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.isRequired = builder.isRequired;
    }

    /**
     * <p>
     * The dataset field name.
     * </p>
     * 
     * @return The dataset field name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The dataset field type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataLakeDatasetSchemaFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The dataset field type.
     * @see DataLakeDatasetSchemaFieldType
     */
    public final DataLakeDatasetSchemaFieldType type() {
        return DataLakeDatasetSchemaFieldType.fromValue(type);
    }

    /**
     * <p>
     * The dataset field type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataLakeDatasetSchemaFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The dataset field type.
     * @see DataLakeDatasetSchemaFieldType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Indicate if the field is required or not.
     * </p>
     * 
     * @return Indicate if the field is required or not.
     */
    public final Boolean isRequired() {
        return isRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeDatasetSchemaField)) {
            return false;
        }
        DataLakeDatasetSchemaField other = (DataLakeDatasetSchemaField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(isRequired(), other.isRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeDatasetSchemaField").add("Name", name()).add("Type", typeAsString())
                .add("IsRequired", isRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "isRequired":
            return Optional.ofNullable(clazz.cast(isRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeDatasetSchemaField, T> g) {
        return obj -> g.apply((DataLakeDatasetSchemaField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeDatasetSchemaField> {
        /**
         * <p>
         * The dataset field name.
         * </p>
         * 
         * @param name
         *        The dataset field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The dataset field type.
         * </p>
         * 
         * @param type
         *        The dataset field type.
         * @see DataLakeDatasetSchemaFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeDatasetSchemaFieldType
         */
        Builder type(String type);

        /**
         * <p>
         * The dataset field type.
         * </p>
         * 
         * @param type
         *        The dataset field type.
         * @see DataLakeDatasetSchemaFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeDatasetSchemaFieldType
         */
        Builder type(DataLakeDatasetSchemaFieldType type);

        /**
         * <p>
         * Indicate if the field is required or not.
         * </p>
         * 
         * @param isRequired
         *        Indicate if the field is required or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequired(Boolean isRequired);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private Boolean isRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeDatasetSchemaField model) {
            name(model.name);
            type(model.type);
            isRequired(model.isRequired);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataLakeDatasetSchemaFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getIsRequired() {
            return isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        @Override
        public DataLakeDatasetSchemaField build() {
            return new DataLakeDatasetSchemaField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
