/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for ListDataIntegrationFlows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataIntegrationFlowsResponse extends SupplyChainResponse implements
        ToCopyableBuilder<ListDataIntegrationFlowsResponse.Builder, ListDataIntegrationFlowsResponse> {
    private static final SdkField<List<DataIntegrationFlow>> FLOWS_FIELD = SdkField
            .<List<DataIntegrationFlow>> builder(MarshallingType.LIST)
            .memberName("flows")
            .getter(getter(ListDataIntegrationFlowsResponse::flows))
            .setter(setter(Builder::flows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataIntegrationFlow> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataIntegrationFlow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataIntegrationFlowsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLOWS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DataIntegrationFlow> flows;

    private final String nextToken;

    private ListDataIntegrationFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.flows = builder.flows;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Flows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFlows() {
        return flows != null && !(flows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response parameters for ListDataIntegrationFlows.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlows} method.
     * </p>
     * 
     * @return The response parameters for ListDataIntegrationFlows.
     */
    public final List<DataIntegrationFlow> flows() {
        return flows;
    }

    /**
     * <p>
     * The pagination token to fetch the next page of the DataIntegrationFlows.
     * </p>
     * 
     * @return The pagination token to fetch the next page of the DataIntegrationFlows.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFlows() ? flows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataIntegrationFlowsResponse)) {
            return false;
        }
        ListDataIntegrationFlowsResponse other = (ListDataIntegrationFlowsResponse) obj;
        return hasFlows() == other.hasFlows() && Objects.equals(flows(), other.flows())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataIntegrationFlowsResponse").add("Flows", hasFlows() ? flows() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flows":
            return Optional.ofNullable(clazz.cast(flows()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataIntegrationFlowsResponse, T> g) {
        return obj -> g.apply((ListDataIntegrationFlowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataIntegrationFlowsResponse> {
        /**
         * <p>
         * The response parameters for ListDataIntegrationFlows.
         * </p>
         * 
         * @param flows
         *        The response parameters for ListDataIntegrationFlows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(Collection<DataIntegrationFlow> flows);

        /**
         * <p>
         * The response parameters for ListDataIntegrationFlows.
         * </p>
         * 
         * @param flows
         *        The response parameters for ListDataIntegrationFlows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(DataIntegrationFlow... flows);

        /**
         * <p>
         * The response parameters for ListDataIntegrationFlows.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow.Builder#build()} is called
         * immediately and its result is passed to {@link #flows(List<DataIntegrationFlow>)}.
         * 
         * @param flows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flows(java.util.Collection<DataIntegrationFlow>)
         */
        Builder flows(Consumer<DataIntegrationFlow.Builder>... flows);

        /**
         * <p>
         * The pagination token to fetch the next page of the DataIntegrationFlows.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to fetch the next page of the DataIntegrationFlows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private List<DataIntegrationFlow> flows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataIntegrationFlowsResponse model) {
            super(model);
            flows(model.flows);
            nextToken(model.nextToken);
        }

        public final List<DataIntegrationFlow.Builder> getFlows() {
            List<DataIntegrationFlow.Builder> result = DataIntegrationFlowListCopier.copyToBuilder(this.flows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlows(Collection<DataIntegrationFlow.BuilderImpl> flows) {
            this.flows = DataIntegrationFlowListCopier.copyFromBuilder(flows);
        }

        @Override
        public final Builder flows(Collection<DataIntegrationFlow> flows) {
            this.flows = DataIntegrationFlowListCopier.copy(flows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(DataIntegrationFlow... flows) {
            flows(Arrays.asList(flows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Consumer<DataIntegrationFlow.Builder>... flows) {
            flows(Stream.of(flows).map(c -> DataIntegrationFlow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataIntegrationFlowsResponse build() {
            return new ListDataIntegrationFlowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
