/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset options used in dataset source and target configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowDatasetOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowDatasetOptions.Builder, DataIntegrationFlowDatasetOptions> {
    private static final SdkField<String> LOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadType").getter(getter(DataIntegrationFlowDatasetOptions::loadTypeAsString))
            .setter(setter(Builder::loadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadType").build()).build();

    private static final SdkField<Boolean> DEDUPE_RECORDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dedupeRecords").getter(getter(DataIntegrationFlowDatasetOptions::dedupeRecords))
            .setter(setter(Builder::dedupeRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_TYPE_FIELD,
            DEDUPE_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("loadType", LOAD_TYPE_FIELD);
                    put("dedupeRecords", DEDUPE_RECORDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String loadType;

    private final Boolean dedupeRecords;

    private DataIntegrationFlowDatasetOptions(BuilderImpl builder) {
        this.loadType = builder.loadType;
        this.dedupeRecords = builder.dedupeRecords;
    }

    /**
     * <p>
     * The dataset data load type in dataset options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loadType} will
     * return {@link DataIntegrationFlowLoadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #loadTypeAsString}.
     * </p>
     * 
     * @return The dataset data load type in dataset options.
     * @see DataIntegrationFlowLoadType
     */
    public final DataIntegrationFlowLoadType loadType() {
        return DataIntegrationFlowLoadType.fromValue(loadType);
    }

    /**
     * <p>
     * The dataset data load type in dataset options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loadType} will
     * return {@link DataIntegrationFlowLoadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #loadTypeAsString}.
     * </p>
     * 
     * @return The dataset data load type in dataset options.
     * @see DataIntegrationFlowLoadType
     */
    public final String loadTypeAsString() {
        return loadType;
    }

    /**
     * <p>
     * The dataset load option to remove duplicates.
     * </p>
     * 
     * @return The dataset load option to remove duplicates.
     */
    public final Boolean dedupeRecords() {
        return dedupeRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedupeRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDatasetOptions)) {
            return false;
        }
        DataIntegrationFlowDatasetOptions other = (DataIntegrationFlowDatasetOptions) obj;
        return Objects.equals(loadTypeAsString(), other.loadTypeAsString())
                && Objects.equals(dedupeRecords(), other.dedupeRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowDatasetOptions").add("LoadType", loadTypeAsString())
                .add("DedupeRecords", dedupeRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadType":
            return Optional.ofNullable(clazz.cast(loadTypeAsString()));
        case "dedupeRecords":
            return Optional.ofNullable(clazz.cast(dedupeRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDatasetOptions, T> g) {
        return obj -> g.apply((DataIntegrationFlowDatasetOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowDatasetOptions> {
        /**
         * <p>
         * The dataset data load type in dataset options.
         * </p>
         * 
         * @param loadType
         *        The dataset data load type in dataset options.
         * @see DataIntegrationFlowLoadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowLoadType
         */
        Builder loadType(String loadType);

        /**
         * <p>
         * The dataset data load type in dataset options.
         * </p>
         * 
         * @param loadType
         *        The dataset data load type in dataset options.
         * @see DataIntegrationFlowLoadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowLoadType
         */
        Builder loadType(DataIntegrationFlowLoadType loadType);

        /**
         * <p>
         * The dataset load option to remove duplicates.
         * </p>
         * 
         * @param dedupeRecords
         *        The dataset load option to remove duplicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedupeRecords(Boolean dedupeRecords);
    }

    static final class BuilderImpl implements Builder {
        private String loadType;

        private Boolean dedupeRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDatasetOptions model) {
            loadType(model.loadType);
            dedupeRecords(model.dedupeRecords);
        }

        public final String getLoadType() {
            return loadType;
        }

        public final void setLoadType(String loadType) {
            this.loadType = loadType;
        }

        @Override
        public final Builder loadType(String loadType) {
            this.loadType = loadType;
            return this;
        }

        @Override
        public final Builder loadType(DataIntegrationFlowLoadType loadType) {
            this.loadType(loadType == null ? null : loadType.toString());
            return this;
        }

        public final Boolean getDedupeRecords() {
            return dedupeRecords;
        }

        public final void setDedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
        }

        @Override
        public final Builder dedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
            return this;
        }

        @Override
        public DataIntegrationFlowDatasetOptions build() {
            return new DataIntegrationFlowDatasetOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
