/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schema details of the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeDatasetSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeDatasetSchema.Builder, DataLakeDatasetSchema> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataLakeDatasetSchema::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<DataLakeDatasetSchemaField>> FIELDS_FIELD = SdkField
            .<List<DataLakeDatasetSchemaField>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(DataLakeDatasetSchema::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeDatasetSchemaField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeDatasetSchemaField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("fields", FIELDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<DataLakeDatasetSchemaField> fields;

    private DataLakeDatasetSchema(BuilderImpl builder) {
        this.name = builder.name;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * The name of the dataset schema.
     * </p>
     * 
     * @return The name of the dataset schema.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of field details of the dataset schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The list of field details of the dataset schema.
     */
    public final List<DataLakeDatasetSchemaField> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeDatasetSchema)) {
            return false;
        }
        DataLakeDatasetSchema other = (DataLakeDatasetSchema) obj;
        return Objects.equals(name(), other.name()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeDatasetSchema").add("Name", name()).add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeDatasetSchema, T> g) {
        return obj -> g.apply((DataLakeDatasetSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeDatasetSchema> {
        /**
         * <p>
         * The name of the dataset schema.
         * </p>
         * 
         * @param name
         *        The name of the dataset schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of field details of the dataset schema.
         * </p>
         * 
         * @param fields
         *        The list of field details of the dataset schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<DataLakeDatasetSchemaField> fields);

        /**
         * <p>
         * The list of field details of the dataset schema.
         * </p>
         * 
         * @param fields
         *        The list of field details of the dataset schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(DataLakeDatasetSchemaField... fields);

        /**
         * <p>
         * The list of field details of the dataset schema.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaField.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaField.Builder#build()} is
         * called immediately and its result is passed to {@link #fields(List<DataLakeDatasetSchemaField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<DataLakeDatasetSchemaField>)
         */
        Builder fields(Consumer<DataLakeDatasetSchemaField.Builder>... fields);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<DataLakeDatasetSchemaField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeDatasetSchema model) {
            name(model.name);
            fields(model.fields);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataLakeDatasetSchemaField.Builder> getFields() {
            List<DataLakeDatasetSchemaField.Builder> result = DataLakeDatasetSchemaFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<DataLakeDatasetSchemaField.BuilderImpl> fields) {
            this.fields = DataLakeDatasetSchemaFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<DataLakeDatasetSchemaField> fields) {
            this.fields = DataLakeDatasetSchemaFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(DataLakeDatasetSchemaField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<DataLakeDatasetSchemaField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> DataLakeDatasetSchemaField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataLakeDatasetSchema build() {
            return new DataLakeDatasetSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
