/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for DeleteInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstanceResponse extends SupplyChainResponse implements
        ToCopyableBuilder<DeleteInstanceResponse.Builder, DeleteInstanceResponse> {
    private static final SdkField<Instance> INSTANCE_FIELD = SdkField.<Instance> builder(MarshallingType.SDK_POJO)
            .memberName("instance").getter(getter(DeleteInstanceResponse::instance)).setter(setter(Builder::instance))
            .constructor(Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("instance", INSTANCE_FIELD);
                }
            });

    private final Instance instance;

    private DeleteInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instance = builder.instance;
    }

    /**
     * <p>
     * The AWS Supply Chain instance resource data details.
     * </p>
     * 
     * @return The AWS Supply Chain instance resource data details.
     */
    public final Instance instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceResponse)) {
            return false;
        }
        DeleteInstanceResponse other = (DeleteInstanceResponse) obj;
        return Objects.equals(instance(), other.instance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInstanceResponse").add("Instance", instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceResponse, T> g) {
        return obj -> g.apply((DeleteInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInstanceResponse> {
        /**
         * <p>
         * The AWS Supply Chain instance resource data details.
         * </p>
         * 
         * @param instance
         *        The AWS Supply Chain instance resource data details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);

        /**
         * <p>
         * The AWS Supply Chain instance resource data details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Instance.Builder} avoiding the need to
         * create one manually via {@link Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Instance.Builder#build()} is called immediately and its result is
         * passed to {@link #instance(Instance)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(Instance)
         */
        default Builder instance(Consumer<Instance.Builder> instance) {
            return instance(Instance.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private Instance instance;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceResponse model) {
            super(model);
            instance(model.instance);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        @Override
        public DeleteInstanceResponse build() {
            return new DeleteInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
