/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for GetDataIntegrationFlow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataIntegrationFlowResponse extends SupplyChainResponse implements
        ToCopyableBuilder<GetDataIntegrationFlowResponse.Builder, GetDataIntegrationFlowResponse> {
    private static final SdkField<DataIntegrationFlow> FLOW_FIELD = SdkField
            .<DataIntegrationFlow> builder(MarshallingType.SDK_POJO).memberName("flow")
            .getter(getter(GetDataIntegrationFlowResponse::flow)).setter(setter(Builder::flow))
            .constructor(DataIntegrationFlow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("flow", FLOW_FIELD);
                }
            });

    private final DataIntegrationFlow flow;

    private GetDataIntegrationFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flow = builder.flow;
    }

    /**
     * <p>
     * The details of the DataIntegrationFlow returned.
     * </p>
     * 
     * @return The details of the DataIntegrationFlow returned.
     */
    public final DataIntegrationFlow flow() {
        return flow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataIntegrationFlowResponse)) {
            return false;
        }
        GetDataIntegrationFlowResponse other = (GetDataIntegrationFlowResponse) obj;
        return Objects.equals(flow(), other.flow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataIntegrationFlowResponse").add("Flow", flow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flow":
            return Optional.ofNullable(clazz.cast(flow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataIntegrationFlowResponse, T> g) {
        return obj -> g.apply((GetDataIntegrationFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataIntegrationFlowResponse> {
        /**
         * <p>
         * The details of the DataIntegrationFlow returned.
         * </p>
         * 
         * @param flow
         *        The details of the DataIntegrationFlow returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flow(DataIntegrationFlow flow);

        /**
         * <p>
         * The details of the DataIntegrationFlow returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationFlow.Builder} avoiding the
         * need to create one manually via {@link DataIntegrationFlow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlow.Builder#build()} is called immediately and
         * its result is passed to {@link #flow(DataIntegrationFlow)}.
         * 
         * @param flow
         *        a consumer that will call methods on {@link DataIntegrationFlow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flow(DataIntegrationFlow)
         */
        default Builder flow(Consumer<DataIntegrationFlow.Builder> flow) {
            return flow(DataIntegrationFlow.builder().applyMutation(flow).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private DataIntegrationFlow flow;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataIntegrationFlowResponse model) {
            super(model);
            flow(model.flow);
        }

        public final DataIntegrationFlow.Builder getFlow() {
            return flow != null ? flow.toBuilder() : null;
        }

        public final void setFlow(DataIntegrationFlow.BuilderImpl flow) {
            this.flow = flow != null ? flow.build() : null;
        }

        @Override
        public final Builder flow(DataIntegrationFlow flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public GetDataIntegrationFlowResponse build() {
            return new GetDataIntegrationFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
