/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for GetDataLakeDataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataLakeDatasetRequest extends SupplyChainRequest implements
        ToCopyableBuilder<GetDataLakeDatasetRequest.Builder, GetDataLakeDatasetRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(GetDataLakeDatasetRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetDataLakeDatasetRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDataLakeDatasetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NAMESPACE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("instanceId", INSTANCE_ID_FIELD);
                    put("namespace", NAMESPACE_FIELD);
                    put("name", NAME_FIELD);
                }
            });

    private final String instanceId;

    private final String namespace;

    private final String name;

    private GetDataLakeDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.namespace = builder.namespace;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance identifier.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name space of the dataset. The available values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
     * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
     * >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>default</b> - For datasets with custom user-defined schemas.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name space of the dataset. The available values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
     *         href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
     *         >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>default</b> - For datasets with custom user-defined schemas.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities under <a
     * href
     * ="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://docs.aws.amazon.com
     * /aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     * </p>
     * 
     * @return The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities
     *         under <a
     *         href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://
     *         docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataLakeDatasetRequest)) {
            return false;
        }
        GetDataLakeDatasetRequest other = (GetDataLakeDatasetRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataLakeDatasetRequest").add("InstanceId", instanceId()).add("Namespace", namespace())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataLakeDatasetRequest, T> g) {
        return obj -> g.apply((GetDataLakeDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataLakeDatasetRequest> {
        /**
         * <p>
         * The Amazon Web Services Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The Amazon Web Services Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name space of the dataset. The available values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
         * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         * >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>default</b> - For datasets with custom user-defined schemas.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The name space of the dataset. The available values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
         *        href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         *        >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>default</b> - For datasets with custom user-defined schemas.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities under
         * <a href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://docs.aws.
         * amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * </p>
         * 
         * @param name
         *        The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data
         *        entities under <a
         *        href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         *        >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String namespace;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataLakeDatasetRequest model) {
            super(model);
            instanceId(model.instanceId);
            namespace(model.namespace);
            name(model.name);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataLakeDatasetRequest build() {
            return new GetDataLakeDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
