/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for UpdateDataLakeDataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataLakeDatasetResponse extends SupplyChainResponse implements
        ToCopyableBuilder<GetDataLakeDatasetResponse.Builder, GetDataLakeDatasetResponse> {
    private static final SdkField<DataLakeDataset> DATASET_FIELD = SdkField.<DataLakeDataset> builder(MarshallingType.SDK_POJO)
            .memberName("dataset").getter(getter(GetDataLakeDatasetResponse::dataset)).setter(setter(Builder::dataset))
            .constructor(DataLakeDataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("dataset", DATASET_FIELD);
                }
            });

    private final DataLakeDataset dataset;

    private GetDataLakeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.dataset = builder.dataset;
    }

    /**
     * <p>
     * The fetched dataset details.
     * </p>
     * 
     * @return The fetched dataset details.
     */
    public final DataLakeDataset dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataLakeDatasetResponse)) {
            return false;
        }
        GetDataLakeDatasetResponse other = (GetDataLakeDatasetResponse) obj;
        return Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataLakeDatasetResponse").add("Dataset", dataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataLakeDatasetResponse, T> g) {
        return obj -> g.apply((GetDataLakeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataLakeDatasetResponse> {
        /**
         * <p>
         * The fetched dataset details.
         * </p>
         * 
         * @param dataset
         *        The fetched dataset details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(DataLakeDataset dataset);

        /**
         * <p>
         * The fetched dataset details.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeDataset.Builder} avoiding the
         * need to create one manually via {@link DataLakeDataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeDataset.Builder#build()} is called immediately and its
         * result is passed to {@link #dataset(DataLakeDataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link DataLakeDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(DataLakeDataset)
         */
        default Builder dataset(Consumer<DataLakeDataset.Builder> dataset) {
            return dataset(DataLakeDataset.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private DataLakeDataset dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataLakeDatasetResponse model) {
            super(model);
            dataset(model.dataset);
        }

        public final DataLakeDataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(DataLakeDataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(DataLakeDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public GetDataLakeDatasetResponse build() {
            return new GetDataLakeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
