/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for SendDataIntegrationEvent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDataIntegrationEventRequest extends SupplyChainRequest implements
        ToCopyableBuilder<SendDataIntegrationEventRequest.Builder, SendDataIntegrationEventRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(SendDataIntegrationEventRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(SendDataIntegrationEventRequest::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("data")
            .getter(getter(SendDataIntegrationEventRequest::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> EVENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventGroupId").getter(getter(SendDataIntegrationEventRequest::eventGroupId))
            .setter(setter(Builder::eventGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventGroupId").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp")
            .getter(getter(SendDataIntegrationEventRequest::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(SendDataIntegrationEventRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVENT_TYPE_FIELD, DATA_FIELD, EVENT_GROUP_ID_FIELD, EVENT_TIMESTAMP_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("instanceId", INSTANCE_ID_FIELD);
                    put("eventType", EVENT_TYPE_FIELD);
                    put("data", DATA_FIELD);
                    put("eventGroupId", EVENT_GROUP_ID_FIELD);
                    put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final String instanceId;

    private final String eventType;

    private final String data;

    private final String eventGroupId;

    private final Instant eventTimestamp;

    private final String clientToken;

    private SendDataIntegrationEventRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.eventType = builder.eventType;
        this.data = builder.data;
        this.eventGroupId = builder.eventGroupId;
        this.eventTimestamp = builder.eventTimestamp;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The AWS Supply Chain instance identifier.
     * </p>
     * 
     * @return The AWS Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The data event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The data event type.
     * @see DataIntegrationEventType
     */
    public final DataIntegrationEventType eventType() {
        return DataIntegrationEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The data event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The data event type.
     * @see DataIntegrationEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The data payload of the event. For more information on the data schema to use, see <a
     * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">Data entities supported
     * in AWS Supply Chain </a>.
     * </p>
     * 
     * @return The data payload of the event. For more information on the data schema to use, see <a
     *         href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">Data entities
     *         supported in AWS Supply Chain </a>.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * Event identifier (for example, orderId for InboundOrder) used for data sharing or partitioning.
     * </p>
     * 
     * @return Event identifier (for example, orderId for InboundOrder) used for data sharing or partitioning.
     */
    public final String eventGroupId() {
        return eventGroupId;
    }

    /**
     * <p>
     * The event timestamp (in epoch seconds).
     * </p>
     * 
     * @return The event timestamp (in epoch seconds).
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The idempotent client token.
     * </p>
     * 
     * @return The idempotent client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(eventGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataIntegrationEventRequest)) {
            return false;
        }
        SendDataIntegrationEventRequest other = (SendDataIntegrationEventRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(data(), other.data()) && Objects.equals(eventGroupId(), other.eventGroupId())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendDataIntegrationEventRequest").add("InstanceId", instanceId())
                .add("EventType", eventTypeAsString()).add("Data", data() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventGroupId", eventGroupId()).add("EventTimestamp", eventTimestamp()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "eventGroupId":
            return Optional.ofNullable(clazz.cast(eventGroupId()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendDataIntegrationEventRequest, T> g) {
        return obj -> g.apply((SendDataIntegrationEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendDataIntegrationEventRequest> {
        /**
         * <p>
         * The AWS Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The AWS Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The data event type.
         * </p>
         * 
         * @param eventType
         *        The data event type.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The data event type.
         * </p>
         * 
         * @param eventType
         *        The data event type.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(DataIntegrationEventType eventType);

        /**
         * <p>
         * The data payload of the event. For more information on the data schema to use, see <a
         * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">Data entities
         * supported in AWS Supply Chain </a>.
         * </p>
         * 
         * @param data
         *        The data payload of the event. For more information on the data schema to use, see <a
         *        href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">Data entities
         *        supported in AWS Supply Chain </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * Event identifier (for example, orderId for InboundOrder) used for data sharing or partitioning.
         * </p>
         * 
         * @param eventGroupId
         *        Event identifier (for example, orderId for InboundOrder) used for data sharing or partitioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventGroupId(String eventGroupId);

        /**
         * <p>
         * The event timestamp (in epoch seconds).
         * </p>
         * 
         * @param eventTimestamp
         *        The event timestamp (in epoch seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The idempotent client token.
         * </p>
         * 
         * @param clientToken
         *        The idempotent client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String eventType;

        private String data;

        private String eventGroupId;

        private Instant eventTimestamp;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataIntegrationEventRequest model) {
            super(model);
            instanceId(model.instanceId);
            eventType(model.eventType);
            data(model.data);
            eventGroupId(model.eventGroupId);
            eventTimestamp(model.eventTimestamp);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DataIntegrationEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getEventGroupId() {
            return eventGroupId;
        }

        public final void setEventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
        }

        @Override
        public final Builder eventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataIntegrationEventRequest build() {
            return new SendDataIntegrationEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
