/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for UpdateDataIntegrationFlow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataIntegrationFlowRequest extends SupplyChainRequest implements
        ToCopyableBuilder<UpdateDataIntegrationFlowRequest.Builder, UpdateDataIntegrationFlowRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(UpdateDataIntegrationFlowRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDataIntegrationFlowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<List<DataIntegrationFlowSource>> SOURCES_FIELD = SdkField
            .<List<DataIntegrationFlowSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(UpdateDataIntegrationFlowRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataIntegrationFlowSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataIntegrationFlowSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataIntegrationFlowTransformation> TRANSFORMATION_FIELD = SdkField
            .<DataIntegrationFlowTransformation> builder(MarshallingType.SDK_POJO).memberName("transformation")
            .getter(getter(UpdateDataIntegrationFlowRequest::transformation)).setter(setter(Builder::transformation))
            .constructor(DataIntegrationFlowTransformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformation").build()).build();

    private static final SdkField<DataIntegrationFlowTarget> TARGET_FIELD = SdkField
            .<DataIntegrationFlowTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(UpdateDataIntegrationFlowRequest::target)).setter(setter(Builder::target))
            .constructor(DataIntegrationFlowTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            SOURCES_FIELD, TRANSFORMATION_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("instanceId", INSTANCE_ID_FIELD);
                    put("name", NAME_FIELD);
                    put("sources", SOURCES_FIELD);
                    put("transformation", TRANSFORMATION_FIELD);
                    put("target", TARGET_FIELD);
                }
            });

    private final String instanceId;

    private final String name;

    private final List<DataIntegrationFlowSource> sources;

    private final DataIntegrationFlowTransformation transformation;

    private final DataIntegrationFlowTarget target;

    private UpdateDataIntegrationFlowRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.sources = builder.sources;
        this.transformation = builder.transformation;
        this.target = builder.target;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance identifier.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the DataIntegrationFlow to be updated.
     * </p>
     * 
     * @return The name of the DataIntegrationFlow to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new source configurations for the DataIntegrationFlow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The new source configurations for the DataIntegrationFlow.
     */
    public final List<DataIntegrationFlowSource> sources() {
        return sources;
    }

    /**
     * <p>
     * The new transformation configurations for the DataIntegrationFlow.
     * </p>
     * 
     * @return The new transformation configurations for the DataIntegrationFlow.
     */
    public final DataIntegrationFlowTransformation transformation() {
        return transformation;
    }

    /**
     * <p>
     * The new target configurations for the DataIntegrationFlow.
     * </p>
     * 
     * @return The new target configurations for the DataIntegrationFlow.
     */
    public final DataIntegrationFlowTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transformation());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataIntegrationFlowRequest)) {
            return false;
        }
        UpdateDataIntegrationFlowRequest other = (UpdateDataIntegrationFlowRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && hasSources() == other.hasSources() && Objects.equals(sources(), other.sources())
                && Objects.equals(transformation(), other.transformation()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataIntegrationFlowRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Sources", hasSources() ? sources() : null).add("Transformation", transformation()).add("Target", target())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "transformation":
            return Optional.ofNullable(clazz.cast(transformation()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataIntegrationFlowRequest, T> g) {
        return obj -> g.apply((UpdateDataIntegrationFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataIntegrationFlowRequest> {
        /**
         * <p>
         * The Amazon Web Services Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The Amazon Web Services Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the DataIntegrationFlow to be updated.
         * </p>
         * 
         * @param name
         *        The name of the DataIntegrationFlow to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new source configurations for the DataIntegrationFlow.
         * </p>
         * 
         * @param sources
         *        The new source configurations for the DataIntegrationFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<DataIntegrationFlowSource> sources);

        /**
         * <p>
         * The new source configurations for the DataIntegrationFlow.
         * </p>
         * 
         * @param sources
         *        The new source configurations for the DataIntegrationFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(DataIntegrationFlowSource... sources);

        /**
         * <p>
         * The new source configurations for the DataIntegrationFlow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSource.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<DataIntegrationFlowSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<DataIntegrationFlowSource>)
         */
        Builder sources(Consumer<DataIntegrationFlowSource.Builder>... sources);

        /**
         * <p>
         * The new transformation configurations for the DataIntegrationFlow.
         * </p>
         * 
         * @param transformation
         *        The new transformation configurations for the DataIntegrationFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformation(DataIntegrationFlowTransformation transformation);

        /**
         * <p>
         * The new transformation configurations for the DataIntegrationFlow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowTransformation.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowTransformation.Builder#build()} is called
         * immediately and its result is passed to {@link #transformation(DataIntegrationFlowTransformation)}.
         * 
         * @param transformation
         *        a consumer that will call methods on {@link DataIntegrationFlowTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformation(DataIntegrationFlowTransformation)
         */
        default Builder transformation(Consumer<DataIntegrationFlowTransformation.Builder> transformation) {
            return transformation(DataIntegrationFlowTransformation.builder().applyMutation(transformation).build());
        }

        /**
         * <p>
         * The new target configurations for the DataIntegrationFlow.
         * </p>
         * 
         * @param target
         *        The new target configurations for the DataIntegrationFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(DataIntegrationFlowTarget target);

        /**
         * <p>
         * The new target configurations for the DataIntegrationFlow.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationFlowTarget.Builder}
         * avoiding the need to create one manually via {@link DataIntegrationFlowTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #target(DataIntegrationFlowTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link DataIntegrationFlowTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(DataIntegrationFlowTarget)
         */
        default Builder target(Consumer<DataIntegrationFlowTarget.Builder> target) {
            return target(DataIntegrationFlowTarget.builder().applyMutation(target).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private List<DataIntegrationFlowSource> sources = DefaultSdkAutoConstructList.getInstance();

        private DataIntegrationFlowTransformation transformation;

        private DataIntegrationFlowTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataIntegrationFlowRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            sources(model.sources);
            transformation(model.transformation);
            target(model.target);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataIntegrationFlowSource.Builder> getSources() {
            List<DataIntegrationFlowSource.Builder> result = DataIntegrationFlowSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<DataIntegrationFlowSource.BuilderImpl> sources) {
            this.sources = DataIntegrationFlowSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<DataIntegrationFlowSource> sources) {
            this.sources = DataIntegrationFlowSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(DataIntegrationFlowSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<DataIntegrationFlowSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> DataIntegrationFlowSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataIntegrationFlowTransformation.Builder getTransformation() {
            return transformation != null ? transformation.toBuilder() : null;
        }

        public final void setTransformation(DataIntegrationFlowTransformation.BuilderImpl transformation) {
            this.transformation = transformation != null ? transformation.build() : null;
        }

        @Override
        public final Builder transformation(DataIntegrationFlowTransformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public final DataIntegrationFlowTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(DataIntegrationFlowTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DataIntegrationFlowTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataIntegrationFlowRequest build() {
            return new UpdateDataIntegrationFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
