/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DataIntegrationFlow target parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowTarget.Builder, DataIntegrationFlowTarget> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(DataIntegrationFlowTarget::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<DataIntegrationFlowS3TargetConfiguration> S3_TARGET_FIELD = SdkField
            .<DataIntegrationFlowS3TargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Target")
            .getter(getter(DataIntegrationFlowTarget::s3Target)).setter(setter(Builder::s3Target))
            .constructor(DataIntegrationFlowS3TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Target").build()).build();

    private static final SdkField<DataIntegrationFlowDatasetTargetConfiguration> DATASET_TARGET_FIELD = SdkField
            .<DataIntegrationFlowDatasetTargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("datasetTarget")
            .getter(getter(DataIntegrationFlowTarget::datasetTarget)).setter(setter(Builder::datasetTarget))
            .constructor(DataIntegrationFlowDatasetTargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            S3_TARGET_FIELD, DATASET_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetType;

    private final DataIntegrationFlowS3TargetConfiguration s3Target;

    private final DataIntegrationFlowDatasetTargetConfiguration datasetTarget;

    private DataIntegrationFlowTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.s3Target = builder.s3Target;
        this.datasetTarget = builder.datasetTarget;
    }

    /**
     * <p>
     * The DataIntegrationFlow target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link DataIntegrationFlowTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow target type.
     * @see DataIntegrationFlowTargetType
     */
    public final DataIntegrationFlowTargetType targetType() {
        return DataIntegrationFlowTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The DataIntegrationFlow target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link DataIntegrationFlowTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow target type.
     * @see DataIntegrationFlowTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The S3 DataIntegrationFlow target.
     * </p>
     * 
     * @return The S3 DataIntegrationFlow target.
     */
    public final DataIntegrationFlowS3TargetConfiguration s3Target() {
        return s3Target;
    }

    /**
     * <p>
     * The dataset DataIntegrationFlow target.
     * </p>
     * 
     * @return The dataset DataIntegrationFlow target.
     */
    public final DataIntegrationFlowDatasetTargetConfiguration datasetTarget() {
        return datasetTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Target());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowTarget)) {
            return false;
        }
        DataIntegrationFlowTarget other = (DataIntegrationFlowTarget) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(s3Target(), other.s3Target())
                && Objects.equals(datasetTarget(), other.datasetTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowTarget").add("TargetType", targetTypeAsString()).add("S3Target", s3Target())
                .add("DatasetTarget", datasetTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "s3Target":
            return Optional.ofNullable(clazz.cast(s3Target()));
        case "datasetTarget":
            return Optional.ofNullable(clazz.cast(datasetTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("s3Target", S3_TARGET_FIELD);
        map.put("datasetTarget", DATASET_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowTarget, T> g) {
        return obj -> g.apply((DataIntegrationFlowTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowTarget> {
        /**
         * <p>
         * The DataIntegrationFlow target type.
         * </p>
         * 
         * @param targetType
         *        The DataIntegrationFlow target type.
         * @see DataIntegrationFlowTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The DataIntegrationFlow target type.
         * </p>
         * 
         * @param targetType
         *        The DataIntegrationFlow target type.
         * @see DataIntegrationFlowTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowTargetType
         */
        Builder targetType(DataIntegrationFlowTargetType targetType);

        /**
         * <p>
         * The S3 DataIntegrationFlow target.
         * </p>
         * 
         * @param s3Target
         *        The S3 DataIntegrationFlow target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Target(DataIntegrationFlowS3TargetConfiguration s3Target);

        /**
         * <p>
         * The S3 DataIntegrationFlow target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowS3TargetConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowS3TargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowS3TargetConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #s3Target(DataIntegrationFlowS3TargetConfiguration)}.
         * 
         * @param s3Target
         *        a consumer that will call methods on {@link DataIntegrationFlowS3TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Target(DataIntegrationFlowS3TargetConfiguration)
         */
        default Builder s3Target(Consumer<DataIntegrationFlowS3TargetConfiguration.Builder> s3Target) {
            return s3Target(DataIntegrationFlowS3TargetConfiguration.builder().applyMutation(s3Target).build());
        }

        /**
         * <p>
         * The dataset DataIntegrationFlow target.
         * </p>
         * 
         * @param datasetTarget
         *        The dataset DataIntegrationFlow target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTarget(DataIntegrationFlowDatasetTargetConfiguration datasetTarget);

        /**
         * <p>
         * The dataset DataIntegrationFlow target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowDatasetTargetConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowDatasetTargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowDatasetTargetConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #datasetTarget(DataIntegrationFlowDatasetTargetConfiguration)}.
         * 
         * @param datasetTarget
         *        a consumer that will call methods on {@link DataIntegrationFlowDatasetTargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetTarget(DataIntegrationFlowDatasetTargetConfiguration)
         */
        default Builder datasetTarget(Consumer<DataIntegrationFlowDatasetTargetConfiguration.Builder> datasetTarget) {
            return datasetTarget(DataIntegrationFlowDatasetTargetConfiguration.builder().applyMutation(datasetTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetType;

        private DataIntegrationFlowS3TargetConfiguration s3Target;

        private DataIntegrationFlowDatasetTargetConfiguration datasetTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowTarget model) {
            targetType(model.targetType);
            s3Target(model.s3Target);
            datasetTarget(model.datasetTarget);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(DataIntegrationFlowTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final DataIntegrationFlowS3TargetConfiguration.Builder getS3Target() {
            return s3Target != null ? s3Target.toBuilder() : null;
        }

        public final void setS3Target(DataIntegrationFlowS3TargetConfiguration.BuilderImpl s3Target) {
            this.s3Target = s3Target != null ? s3Target.build() : null;
        }

        @Override
        public final Builder s3Target(DataIntegrationFlowS3TargetConfiguration s3Target) {
            this.s3Target = s3Target;
            return this;
        }

        public final DataIntegrationFlowDatasetTargetConfiguration.Builder getDatasetTarget() {
            return datasetTarget != null ? datasetTarget.toBuilder() : null;
        }

        public final void setDatasetTarget(DataIntegrationFlowDatasetTargetConfiguration.BuilderImpl datasetTarget) {
            this.datasetTarget = datasetTarget != null ? datasetTarget.build() : null;
        }

        @Override
        public final Builder datasetTarget(DataIntegrationFlowDatasetTargetConfiguration datasetTarget) {
            this.datasetTarget = datasetTarget;
            return this;
        }

        @Override
        public DataIntegrationFlowTarget build() {
            return new DataIntegrationFlowTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
