/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DataIntegrationFlow transformation parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowTransformation.Builder, DataIntegrationFlowTransformation> {
    private static final SdkField<String> TRANSFORMATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformationType").getter(getter(DataIntegrationFlowTransformation::transformationTypeAsString))
            .setter(setter(Builder::transformationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationType").build())
            .build();

    private static final SdkField<DataIntegrationFlowSQLTransformationConfiguration> SQL_TRANSFORMATION_FIELD = SdkField
            .<DataIntegrationFlowSQLTransformationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("sqlTransformation").getter(getter(DataIntegrationFlowTransformation::sqlTransformation))
            .setter(setter(Builder::sqlTransformation)).constructor(DataIntegrationFlowSQLTransformationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlTransformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMATION_TYPE_FIELD,
            SQL_TRANSFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transformationType;

    private final DataIntegrationFlowSQLTransformationConfiguration sqlTransformation;

    private DataIntegrationFlowTransformation(BuilderImpl builder) {
        this.transformationType = builder.transformationType;
        this.sqlTransformation = builder.sqlTransformation;
    }

    /**
     * <p>
     * The DataIntegrationFlow transformation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformationType} will return {@link DataIntegrationFlowTransformationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #transformationTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow transformation type.
     * @see DataIntegrationFlowTransformationType
     */
    public final DataIntegrationFlowTransformationType transformationType() {
        return DataIntegrationFlowTransformationType.fromValue(transformationType);
    }

    /**
     * <p>
     * The DataIntegrationFlow transformation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformationType} will return {@link DataIntegrationFlowTransformationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #transformationTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow transformation type.
     * @see DataIntegrationFlowTransformationType
     */
    public final String transformationTypeAsString() {
        return transformationType;
    }

    /**
     * <p>
     * The SQL DataIntegrationFlow transformation configuration.
     * </p>
     * 
     * @return The SQL DataIntegrationFlow transformation configuration.
     */
    public final DataIntegrationFlowSQLTransformationConfiguration sqlTransformation() {
        return sqlTransformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sqlTransformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowTransformation)) {
            return false;
        }
        DataIntegrationFlowTransformation other = (DataIntegrationFlowTransformation) obj;
        return Objects.equals(transformationTypeAsString(), other.transformationTypeAsString())
                && Objects.equals(sqlTransformation(), other.sqlTransformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowTransformation").add("TransformationType", transformationTypeAsString())
                .add("SqlTransformation", sqlTransformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformationType":
            return Optional.ofNullable(clazz.cast(transformationTypeAsString()));
        case "sqlTransformation":
            return Optional.ofNullable(clazz.cast(sqlTransformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformationType", TRANSFORMATION_TYPE_FIELD);
        map.put("sqlTransformation", SQL_TRANSFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowTransformation, T> g) {
        return obj -> g.apply((DataIntegrationFlowTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowTransformation> {
        /**
         * <p>
         * The DataIntegrationFlow transformation type.
         * </p>
         * 
         * @param transformationType
         *        The DataIntegrationFlow transformation type.
         * @see DataIntegrationFlowTransformationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowTransformationType
         */
        Builder transformationType(String transformationType);

        /**
         * <p>
         * The DataIntegrationFlow transformation type.
         * </p>
         * 
         * @param transformationType
         *        The DataIntegrationFlow transformation type.
         * @see DataIntegrationFlowTransformationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowTransformationType
         */
        Builder transformationType(DataIntegrationFlowTransformationType transformationType);

        /**
         * <p>
         * The SQL DataIntegrationFlow transformation configuration.
         * </p>
         * 
         * @param sqlTransformation
         *        The SQL DataIntegrationFlow transformation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration sqlTransformation);

        /**
         * <p>
         * The SQL DataIntegrationFlow transformation configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowSQLTransformationConfiguration.Builder} avoiding the need to create one manually
         * via {@link DataIntegrationFlowSQLTransformationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link DataIntegrationFlowSQLTransformationConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration)}.
         * 
         * @param sqlTransformation
         *        a consumer that will call methods on {@link DataIntegrationFlowSQLTransformationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration)
         */
        default Builder sqlTransformation(Consumer<DataIntegrationFlowSQLTransformationConfiguration.Builder> sqlTransformation) {
            return sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration.builder().applyMutation(sqlTransformation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transformationType;

        private DataIntegrationFlowSQLTransformationConfiguration sqlTransformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowTransformation model) {
            transformationType(model.transformationType);
            sqlTransformation(model.sqlTransformation);
        }

        public final String getTransformationType() {
            return transformationType;
        }

        public final void setTransformationType(String transformationType) {
            this.transformationType = transformationType;
        }

        @Override
        public final Builder transformationType(String transformationType) {
            this.transformationType = transformationType;
            return this;
        }

        @Override
        public final Builder transformationType(DataIntegrationFlowTransformationType transformationType) {
            this.transformationType(transformationType == null ? null : transformationType.toString());
            return this;
        }

        public final DataIntegrationFlowSQLTransformationConfiguration.Builder getSqlTransformation() {
            return sqlTransformation != null ? sqlTransformation.toBuilder() : null;
        }

        public final void setSqlTransformation(DataIntegrationFlowSQLTransformationConfiguration.BuilderImpl sqlTransformation) {
            this.sqlTransformation = sqlTransformation != null ? sqlTransformation.build() : null;
        }

        @Override
        public final Builder sqlTransformation(DataIntegrationFlowSQLTransformationConfiguration sqlTransformation) {
            this.sqlTransformation = sqlTransformation;
            return this;
        }

        @Override
        public DataIntegrationFlowTransformation build() {
            return new DataIntegrationFlowTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
