/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for CreateDataLakeDataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataLakeDatasetRequest extends SupplyChainRequest implements
        ToCopyableBuilder<CreateDataLakeDatasetRequest.Builder, CreateDataLakeDatasetRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(CreateDataLakeDatasetRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(CreateDataLakeDatasetRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDataLakeDatasetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<DataLakeDatasetSchema> SCHEMA_FIELD = SdkField
            .<DataLakeDatasetSchema> builder(MarshallingType.SDK_POJO).memberName("schema")
            .getter(getter(CreateDataLakeDatasetRequest::schema)).setter(setter(Builder::schema))
            .constructor(DataLakeDatasetSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataLakeDatasetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDataLakeDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NAMESPACE_FIELD, NAME_FIELD, SCHEMA_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String namespace;

    private final String name;

    private final DataLakeDatasetSchema schema;

    private final String description;

    private final Map<String, String> tags;

    private CreateDataLakeDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.schema = builder.schema;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance identifier.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name space of the dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
     * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
     * >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>default</b> - For datasets with custom user-defined schemas.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name space of the dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
     *         href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
     *         >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>default</b> - For datasets with custom user-defined schemas.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities under <a
     * href
     * ="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://docs.aws.amazon.com
     * /aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     * </p>
     * 
     * @return The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities
     *         under <a
     *         href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://
     *         docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The custom schema of the data lake dataset and is only required when the name space is <b>default</b>.
     * </p>
     * 
     * @return The custom schema of the data lake dataset and is only required when the name space is <b>default</b>.
     */
    public final DataLakeDatasetSchema schema() {
        return schema;
    }

    /**
     * <p>
     * The description of the dataset.
     * </p>
     * 
     * @return The description of the dataset.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeDatasetRequest)) {
            return false;
        }
        CreateDataLakeDatasetRequest other = (CreateDataLakeDatasetRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name()) && Objects.equals(schema(), other.schema())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataLakeDatasetRequest").add("InstanceId", instanceId()).add("Namespace", namespace())
                .add("Name", name()).add("Schema", schema()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataLakeDatasetRequest, T> g) {
        return obj -> g.apply((CreateDataLakeDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataLakeDatasetRequest> {
        /**
         * <p>
         * The Amazon Web Services Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The Amazon Web Services Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name space of the dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
         * href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         * >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>default</b> - For datasets with custom user-defined schemas.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The name space of the dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>asc</b> - For information on the Amazon Web Services Supply Chain supported datasets see <a
         *        href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         *        >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>default</b> - For datasets with custom user-defined schemas.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data entities under
         * <a href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html">https://docs.aws.
         * amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * </p>
         * 
         * @param name
         *        The name of the dataset. For <b>asc</b> name space, the name must be one of the supported data
         *        entities under <a
         *        href="https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html"
         *        >https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The custom schema of the data lake dataset and is only required when the name space is <b>default</b>.
         * </p>
         * 
         * @param schema
         *        The custom schema of the data lake dataset and is only required when the name space is <b>default</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(DataLakeDatasetSchema schema);

        /**
         * <p>
         * The custom schema of the data lake dataset and is only required when the name space is <b>default</b>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeDatasetSchema.Builder} avoiding
         * the need to create one manually via {@link DataLakeDatasetSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeDatasetSchema.Builder#build()} is called immediately and
         * its result is passed to {@link #schema(DataLakeDatasetSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link DataLakeDatasetSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(DataLakeDatasetSchema)
         */
        default Builder schema(Consumer<DataLakeDatasetSchema.Builder> schema) {
            return schema(DataLakeDatasetSchema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The description of the dataset.
         * </p>
         * 
         * @param description
         *        The description of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags of the dataset.
         * </p>
         * 
         * @param tags
         *        The tags of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String namespace;

        private String name;

        private DataLakeDatasetSchema schema;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataLakeDatasetRequest model) {
            super(model);
            instanceId(model.instanceId);
            namespace(model.namespace);
            name(model.name);
            schema(model.schema);
            description(model.description);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataLakeDatasetSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(DataLakeDatasetSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(DataLakeDatasetSchema schema) {
            this.schema = schema;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataLakeDatasetRequest build() {
            return new CreateDataLakeDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
