/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for GetBillOfMaterialsImportJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBillOfMaterialsImportJobResponse extends SupplyChainResponse implements
        ToCopyableBuilder<GetBillOfMaterialsImportJobResponse.Builder, GetBillOfMaterialsImportJobResponse> {
    private static final SdkField<BillOfMaterialsImportJob> JOB_FIELD = SdkField
            .<BillOfMaterialsImportJob> builder(MarshallingType.SDK_POJO).memberName("job")
            .getter(getter(GetBillOfMaterialsImportJobResponse::job)).setter(setter(Builder::job))
            .constructor(BillOfMaterialsImportJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BillOfMaterialsImportJob job;

    private GetBillOfMaterialsImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.job = builder.job;
    }

    /**
     * <p>
     * The BillOfMaterialsImportJob.
     * </p>
     * 
     * @return The BillOfMaterialsImportJob.
     */
    public final BillOfMaterialsImportJob job() {
        return job;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(job());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillOfMaterialsImportJobResponse)) {
            return false;
        }
        GetBillOfMaterialsImportJobResponse other = (GetBillOfMaterialsImportJobResponse) obj;
        return Objects.equals(job(), other.job());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBillOfMaterialsImportJobResponse").add("Job", job()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "job":
            return Optional.ofNullable(clazz.cast(job()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("job", JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBillOfMaterialsImportJobResponse, T> g) {
        return obj -> g.apply((GetBillOfMaterialsImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupplyChainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBillOfMaterialsImportJobResponse> {
        /**
         * <p>
         * The BillOfMaterialsImportJob.
         * </p>
         * 
         * @param job
         *        The BillOfMaterialsImportJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(BillOfMaterialsImportJob job);

        /**
         * <p>
         * The BillOfMaterialsImportJob.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillOfMaterialsImportJob.Builder}
         * avoiding the need to create one manually via {@link BillOfMaterialsImportJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillOfMaterialsImportJob.Builder#build()} is called immediately
         * and its result is passed to {@link #job(BillOfMaterialsImportJob)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link BillOfMaterialsImportJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(BillOfMaterialsImportJob)
         */
        default Builder job(Consumer<BillOfMaterialsImportJob.Builder> job) {
            return job(BillOfMaterialsImportJob.builder().applyMutation(job).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private BillOfMaterialsImportJob job;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillOfMaterialsImportJobResponse model) {
            super(model);
            job(model.job);
        }

        public final BillOfMaterialsImportJob.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        public final void setJob(BillOfMaterialsImportJob.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public final Builder job(BillOfMaterialsImportJob job) {
            this.job = job;
            return this;
        }

        @Override
        public GetBillOfMaterialsImportJobResponse build() {
            return new GetBillOfMaterialsImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
