/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(Instance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(Instance::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Instance::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(Instance::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> WEB_APP_DNS_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webAppDnsDomain").getter(getter(Instance::webAppDnsDomain)).setter(setter(Builder::webAppDnsDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAppDnsDomain").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(Instance::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime").getter(getter(Instance::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(Instance::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> INSTANCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceDescription").getter(getter(Instance::instanceDescription))
            .setter(setter(Builder::instanceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDescription").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(Instance::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Double> VERSION_NUMBER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("versionNumber").getter(getter(Instance::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, STATE_FIELD, ERROR_MESSAGE_FIELD, WEB_APP_DNS_DOMAIN_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, INSTANCE_NAME_FIELD, INSTANCE_DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String awsAccountId;

    private final String state;

    private final String errorMessage;

    private final String webAppDnsDomain;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final String instanceName;

    private final String instanceDescription;

    private final String kmsKeyArn;

    private final Double versionNumber;

    private Instance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.awsAccountId = builder.awsAccountId;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
        this.webAppDnsDomain = builder.webAppDnsDomain;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.instanceName = builder.instanceName;
        this.instanceDescription = builder.instanceDescription;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance identifier.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the instance.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceState
     */
    public final InstanceState state() {
        return InstanceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance error message. If the instance results in an unhealthy state,
     * customers need to check the error message, delete the current instance, and recreate a new one based on the
     * mitigation from the error message.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance error message. If the instance results in an unhealthy
     *         state, customers need to check the error message, delete the current instance, and recreate a new one
     *         based on the mitigation from the error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The WebApp DNS domain name of the instance.
     * </p>
     * 
     * @return The WebApp DNS domain name of the instance.
     */
    public final String webAppDnsDomain() {
        return webAppDnsDomain;
    }

    /**
     * <p>
     * The instance creation timestamp.
     * </p>
     * 
     * @return The instance creation timestamp.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The instance last modified timestamp.
     * </p>
     * 
     * @return The instance last modified timestamp.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance name.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance name.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance description.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance description.
     */
    public final String instanceDescription() {
        return instanceDescription;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you optionally provided for encryption. If
     * you did not provide anything here, AWS Supply Chain uses the Amazon Web Services owned KMS key and nothing is
     * returned.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you optionally provided for
     *         encryption. If you did not provide anything here, AWS Supply Chain uses the Amazon Web Services owned KMS
     *         key and nothing is returned.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The version number of the instance.
     * </p>
     * 
     * @return The version number of the instance.
     */
    public final Double versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(webAppDnsDomain());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(webAppDnsDomain(), other.webAppDnsDomain())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(instanceName(), other.instanceName())
                && Objects.equals(instanceDescription(), other.instanceDescription())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("InstanceId", instanceId()).add("AwsAccountId", awsAccountId())
                .add("State", stateAsString()).add("ErrorMessage", errorMessage()).add("WebAppDnsDomain", webAppDnsDomain())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("InstanceName", instanceName()).add("InstanceDescription", instanceDescription())
                .add("KmsKeyArn", kmsKeyArn()).add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "webAppDnsDomain":
            return Optional.ofNullable(clazz.cast(webAppDnsDomain()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "instanceDescription":
            return Optional.ofNullable(clazz.cast(instanceDescription()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("webAppDnsDomain", WEB_APP_DNS_DOMAIN_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("instanceDescription", INSTANCE_DESCRIPTION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The Amazon Web Services Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The Amazon Web Services Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the instance.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID that owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param state
         *        The state of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param state
         *        The state of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The Amazon Web Services Supply Chain instance error message. If the instance results in an unhealthy state,
         * customers need to check the error message, delete the current instance, and recreate a new one based on the
         * mitigation from the error message.
         * </p>
         * 
         * @param errorMessage
         *        The Amazon Web Services Supply Chain instance error message. If the instance results in an unhealthy
         *        state, customers need to check the error message, delete the current instance, and recreate a new one
         *        based on the mitigation from the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The WebApp DNS domain name of the instance.
         * </p>
         * 
         * @param webAppDnsDomain
         *        The WebApp DNS domain name of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppDnsDomain(String webAppDnsDomain);

        /**
         * <p>
         * The instance creation timestamp.
         * </p>
         * 
         * @param createdTime
         *        The instance creation timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The instance last modified timestamp.
         * </p>
         * 
         * @param lastModifiedTime
         *        The instance last modified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Supply Chain instance name.
         * </p>
         * 
         * @param instanceName
         *        The Amazon Web Services Supply Chain instance name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The Amazon Web Services Supply Chain instance description.
         * </p>
         * 
         * @param instanceDescription
         *        The Amazon Web Services Supply Chain instance description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDescription(String instanceDescription);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you optionally provided for
         * encryption. If you did not provide anything here, AWS Supply Chain uses the Amazon Web Services owned KMS key
         * and nothing is returned.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you optionally provided for
         *        encryption. If you did not provide anything here, AWS Supply Chain uses the Amazon Web Services owned
         *        KMS key and nothing is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The version number of the instance.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Double versionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String awsAccountId;

        private String state;

        private String errorMessage;

        private String webAppDnsDomain;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private String instanceName;

        private String instanceDescription;

        private String kmsKeyArn;

        private Double versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            instanceId(model.instanceId);
            awsAccountId(model.awsAccountId);
            state(model.state);
            errorMessage(model.errorMessage);
            webAppDnsDomain(model.webAppDnsDomain);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            instanceName(model.instanceName);
            instanceDescription(model.instanceDescription);
            kmsKeyArn(model.kmsKeyArn);
            versionNumber(model.versionNumber);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getWebAppDnsDomain() {
            return webAppDnsDomain;
        }

        public final void setWebAppDnsDomain(String webAppDnsDomain) {
            this.webAppDnsDomain = webAppDnsDomain;
        }

        @Override
        public final Builder webAppDnsDomain(String webAppDnsDomain) {
            this.webAppDnsDomain = webAppDnsDomain;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getInstanceDescription() {
            return instanceDescription;
        }

        public final void setInstanceDescription(String instanceDescription) {
            this.instanceDescription = instanceDescription;
        }

        @Override
        public final Builder instanceDescription(String instanceDescription) {
            this.instanceDescription = instanceDescription;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Double getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Double versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Double versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
