/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataLakeNamespace;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse;

public class ListDataLakeNamespacesIterable
implements SdkIterable<ListDataLakeNamespacesResponse> {
    private final SupplyChainClient client;
    private final ListDataLakeNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataLakeNamespacesIterable(SupplyChainClient client, ListDataLakeNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataLakeNamespacesResponseFetcher();
    }

    public Iterator<ListDataLakeNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataLakeNamespace> namespaces() {
        Function<ListDataLakeNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.namespaces() != null) {
                return response.namespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataLakeNamespacesResponseFetcher
    implements SyncPageFetcher<ListDataLakeNamespacesResponse> {
        private ListDataLakeNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataLakeNamespacesResponse nextPage(ListDataLakeNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeNamespacesIterable.this.client.listDataLakeNamespaces(ListDataLakeNamespacesIterable.this.firstRequest);
            }
            return ListDataLakeNamespacesIterable.this.client.listDataLakeNamespaces((ListDataLakeNamespacesRequest)((Object)ListDataLakeNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

