/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowExecutionOutputMetadata;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowExecutionSourceInfo;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowExecution> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::instanceId)).setter(DataIntegrationFlowExecution.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::flowName)).setter(DataIntegrationFlowExecution.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::executionId)).setter(DataIntegrationFlowExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::statusAsString)).setter(DataIntegrationFlowExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<DataIntegrationFlowExecutionSourceInfo> SOURCE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceInfo").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::sourceInfo)).setter(DataIntegrationFlowExecution.setter(Builder::sourceInfo)).constructor(DataIntegrationFlowExecutionSourceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInfo").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::message)).setter(DataIntegrationFlowExecution.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::startTime)).setter(DataIntegrationFlowExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::endTime)).setter(DataIntegrationFlowExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<DataIntegrationFlowExecutionOutputMetadata> OUTPUT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputMetadata").getter(DataIntegrationFlowExecution.getter(DataIntegrationFlowExecution::outputMetadata)).setter(DataIntegrationFlowExecution.setter(Builder::outputMetadata)).constructor(DataIntegrationFlowExecutionOutputMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, FLOW_NAME_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, SOURCE_INFO_FIELD, MESSAGE_FIELD, START_TIME_FIELD, END_TIME_FIELD, OUTPUT_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String flowName;
    private final String executionId;
    private final String status;
    private final DataIntegrationFlowExecutionSourceInfo sourceInfo;
    private final String message;
    private final Instant startTime;
    private final Instant endTime;
    private final DataIntegrationFlowExecutionOutputMetadata outputMetadata;

    private DataIntegrationFlowExecution(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.flowName = builder.flowName;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.sourceInfo = builder.sourceInfo;
        this.message = builder.message;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.outputMetadata = builder.outputMetadata;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final DataIntegrationFlowExecutionStatus status() {
        return DataIntegrationFlowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DataIntegrationFlowExecutionSourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    public final String message() {
        return this.message;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final DataIntegrationFlowExecutionOutputMetadata outputMetadata() {
        return this.outputMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowExecution)) {
            return false;
        }
        DataIntegrationFlowExecution other = (DataIntegrationFlowExecution)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceInfo(), other.sourceInfo()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.outputMetadata(), other.outputMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowExecution").add("InstanceId", (Object)this.instanceId()).add("FlowName", (Object)this.flowName()).add("ExecutionId", (Object)this.executionId()).add("Status", (Object)this.statusAsString()).add("SourceInfo", (Object)this.sourceInfo()).add("Message", (Object)this.message()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("OutputMetadata", (Object)this.outputMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sourceInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceInfo()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "outputMetadata": {
                return Optional.ofNullable(clazz.cast(this.outputMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sourceInfo", SOURCE_INFO_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("outputMetadata", OUTPUT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowExecution, T> g) {
        return obj -> g.apply((DataIntegrationFlowExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String flowName;
        private String executionId;
        private String status;
        private DataIntegrationFlowExecutionSourceInfo sourceInfo;
        private String message;
        private Instant startTime;
        private Instant endTime;
        private DataIntegrationFlowExecutionOutputMetadata outputMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowExecution model) {
            this.instanceId(model.instanceId);
            this.flowName(model.flowName);
            this.executionId(model.executionId);
            this.status(model.status);
            this.sourceInfo(model.sourceInfo);
            this.message(model.message);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.outputMetadata(model.outputMetadata);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataIntegrationFlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DataIntegrationFlowExecutionSourceInfo.Builder getSourceInfo() {
            return this.sourceInfo != null ? this.sourceInfo.toBuilder() : null;
        }

        public final void setSourceInfo(DataIntegrationFlowExecutionSourceInfo.BuilderImpl sourceInfo) {
            this.sourceInfo = sourceInfo != null ? sourceInfo.build() : null;
        }

        @Override
        public final Builder sourceInfo(DataIntegrationFlowExecutionSourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final DataIntegrationFlowExecutionOutputMetadata.Builder getOutputMetadata() {
            return this.outputMetadata != null ? this.outputMetadata.toBuilder() : null;
        }

        public final void setOutputMetadata(DataIntegrationFlowExecutionOutputMetadata.BuilderImpl outputMetadata) {
            this.outputMetadata = outputMetadata != null ? outputMetadata.build() : null;
        }

        @Override
        public final Builder outputMetadata(DataIntegrationFlowExecutionOutputMetadata outputMetadata) {
            this.outputMetadata = outputMetadata;
            return this;
        }

        public DataIntegrationFlowExecution build() {
            return new DataIntegrationFlowExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowExecution> {
        public Builder instanceId(String var1);

        public Builder flowName(String var1);

        public Builder executionId(String var1);

        public Builder status(String var1);

        public Builder status(DataIntegrationFlowExecutionStatus var1);

        public Builder sourceInfo(DataIntegrationFlowExecutionSourceInfo var1);

        default public Builder sourceInfo(Consumer<DataIntegrationFlowExecutionSourceInfo.Builder> sourceInfo) {
            return this.sourceInfo((DataIntegrationFlowExecutionSourceInfo)((DataIntegrationFlowExecutionSourceInfo.Builder)DataIntegrationFlowExecutionSourceInfo.builder().applyMutation(sourceInfo)).build());
        }

        public Builder message(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder outputMetadata(DataIntegrationFlowExecutionOutputMetadata var1);

        default public Builder outputMetadata(Consumer<DataIntegrationFlowExecutionOutputMetadata.Builder> outputMetadata) {
            return this.outputMetadata((DataIntegrationFlowExecutionOutputMetadata)((DataIntegrationFlowExecutionOutputMetadata.Builder)DataIntegrationFlowExecutionOutputMetadata.builder().applyMutation(outputMetadata)).build());
        }
    }
}

