/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.supplychain.model.AccessDeniedException;
import software.amazon.awssdk.services.supplychain.model.ConflictException;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.CreateInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.CreateInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.GetInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.GetInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.InternalServerException;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse;
import software.amazon.awssdk.services.supplychain.model.ListInstancesRequest;
import software.amazon.awssdk.services.supplychain.model.ListInstancesResponse;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.supplychain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventResponse;
import software.amazon.awssdk.services.supplychain.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supplychain.model.SupplyChainException;
import software.amazon.awssdk.services.supplychain.model.TagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.TagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.ThrottlingException;
import software.amazon.awssdk.services.supplychain.model.UntagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.UntagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.ValidationException;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable;
import software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable;

/**
 * Service client for accessing AWS Supply Chain. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Supply Chain is a cloud-based application that works with your enterprise resource planning (ERP) and supply
 * chain management systems. Using AWS Supply Chain, you can connect and extract your inventory, supply, and demand
 * related data from existing ERP or supply chain systems into a single data model.
 * </p>
 * <p>
 * The AWS Supply Chain API supports configuration data import for Supply Planning.
 * </p>
 * <p>
 * All AWS Supply chain API operations are Amazon-authenticated and certificate-signed. They not only require the use of
 * the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help
 * facilitate access, trust, and permission policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupplyChainClient extends AwsClient {
    String SERVICE_NAME = "scn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "scn";

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for CreateBillOfMaterialsImportJob.
     * @return Result of the CreateBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillOfMaterialsImportJobResponse createBillOfMaterialsImportJob(
            Consumer<CreateBillOfMaterialsImportJobRequest.Builder> createBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest.builder()
                .applyMutation(createBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create a data pipeline to ingest data from source systems such as Amazon S3
     * buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a temporary dataset
     * along with the data transformation query provided with the API.
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        The request parameters for CreateDataIntegrationFlow.
     * @return Result of the CreateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationFlowResponse createDataIntegrationFlow(
            CreateDataIntegrationFlowRequest createDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create a data pipeline to ingest data from source systems such as Amazon S3
     * buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a temporary dataset
     * along with the data transformation query provided with the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for CreateDataIntegrationFlow.
     * @return Result of the CreateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationFlowResponse createDataIntegrationFlow(
            Consumer<CreateDataIntegrationFlowRequest.Builder> createDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createDataIntegrationFlow(CreateDataIntegrationFlowRequest.builder()
                .applyMutation(createDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake dataset. Developers can
     * create the datasets using their pre-defined or custom schema for a given instance ID, namespace, and dataset
     * name.
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        The request parameters for CreateDataLakeDataset.
     * @return Result of the CreateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeDatasetResponse createDataLakeDataset(CreateDataLakeDatasetRequest createDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake dataset. Developers can
     * create the datasets using their pre-defined or custom schema for a given instance ID, namespace, and dataset
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for CreateDataLakeDataset.
     * @return Result of the CreateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeDatasetResponse createDataLakeDataset(
            Consumer<CreateDataLakeDatasetRequest.Builder> createDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return createDataLakeDataset(CreateDataLakeDatasetRequest.builder().applyMutation(createDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake namespace. Developers can
     * create the namespaces for a given instance ID.
     * </p>
     *
     * @param createDataLakeNamespaceRequest
     *        The request parameters for CreateDataLakeNamespace.
     * @return Result of the CreateDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeNamespaceResponse createDataLakeNamespace(CreateDataLakeNamespaceRequest createDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake namespace. Developers can
     * create the namespaces for a given instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param createDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters for CreateDataLakeNamespace.
     * @return Result of the CreateDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataLakeNamespaceResponse createDataLakeNamespace(
            Consumer<CreateDataLakeNamespaceRequest.Builder> createDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createDataLakeNamespace(CreateDataLakeNamespaceRequest.builder().applyMutation(createDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain instance by applying KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a CreateInstance request, Amazon Web Services Supply Chain
     * immediately returns the instance resource, instance ID, and the initializing state while simultaneously creating
     * all required Amazon Web Services resources for an instance creation. You can use GetInstance to check the status
     * of the instance. If the instance results in an unhealthy state, you need to check the error message, delete the
     * current instance, and recreate a new one based on the mitigation from the error message.
     * </p>
     *
     * @param createInstanceRequest
     *        The request parameters for CreateInstance.
     * @return Result of the CreateInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceResponse createInstance(CreateInstanceRequest createInstanceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain instance by applying KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a CreateInstance request, Amazon Web Services Supply Chain
     * immediately returns the instance resource, instance ID, and the initializing state while simultaneously creating
     * all required Amazon Web Services resources for an instance creation. You can use GetInstance to check the status
     * of the instance. If the instance results in an unhealthy state, you need to check the error message, delete the
     * current instance, and recreate a new one based on the mitigation from the error message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateInstanceRequest.Builder} to create a
     *        request. The request parameters for CreateInstance.
     * @return Result of the CreateInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceResponse createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Enable you to programmatically delete an existing data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        The request parameters for DeleteDataIntegrationFlow.
     * @return Result of the DeleteDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationFlowResponse deleteDataIntegrationFlow(
            DeleteDataIntegrationFlowRequest deleteDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable you to programmatically delete an existing data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for DeleteDataIntegrationFlow.
     * @return Result of the DeleteDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationFlowResponse deleteDataIntegrationFlow(
            Consumer<DeleteDataIntegrationFlowRequest.Builder> deleteDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return deleteDataIntegrationFlow(DeleteDataIntegrationFlowRequest.builder()
                .applyMutation(deleteDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake dataset. Developers can
     * delete the existing datasets for a given instance ID, namespace, and instance name.
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        The request parameters of DeleteDataLakeDataset.
     * @return Result of the DeleteDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeDatasetResponse deleteDataLakeDataset(DeleteDataLakeDatasetRequest deleteDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake dataset. Developers can
     * delete the existing datasets for a given instance ID, namespace, and instance name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of DeleteDataLakeDataset.
     * @return Result of the DeleteDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeDatasetResponse deleteDataLakeDataset(
            Consumer<DeleteDataLakeDatasetRequest.Builder> deleteDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return deleteDataLakeDataset(DeleteDataLakeDatasetRequest.builder().applyMutation(deleteDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake namespace and its underling
     * datasets. Developers can delete the existing namespaces for a given instance ID and namespace name.
     * </p>
     *
     * @param deleteDataLakeNamespaceRequest
     *        The request parameters of DeleteDataLakeNamespace.
     * @return Result of the DeleteDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeNamespaceResponse deleteDataLakeNamespace(DeleteDataLakeNamespaceRequest deleteDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake namespace and its underling
     * datasets. Developers can delete the existing namespaces for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters of DeleteDataLakeNamespace.
     * @return Result of the DeleteDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataLakeNamespaceResponse deleteDataLakeNamespace(
            Consumer<DeleteDataLakeNamespaceRequest.Builder> deleteDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return deleteDataLakeNamespace(DeleteDataLakeNamespaceRequest.builder().applyMutation(deleteDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain instance by deleting the KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a DeleteInstance request, Amazon Web Services Supply Chain
     * immediately returns a response with the instance resource, delete state while cleaning up all Amazon Web Services
     * resources created during the instance creation process. You can use the GetInstance action to check the instance
     * status.
     * </p>
     *
     * @param deleteInstanceRequest
     *        The request parameters for DeleteInstance.
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain instance by deleting the KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a DeleteInstance request, Amazon Web Services Supply Chain
     * immediately returns a response with the instance resource, delete state while cleaning up all Amazon Web Services
     * resources created during the instance creation process. You can use the GetInstance action to check the instance
     * status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteInstanceRequest.Builder} to create a
     *        request. The request parameters for DeleteInstance.
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for GetBillOfMaterialsImportJob.
     * @return Result of the GetBillOfMaterialsImportJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillOfMaterialsImportJobResponse getBillOfMaterialsImportJob(
            Consumer<GetBillOfMaterialsImportJobRequest.Builder> getBillOfMaterialsImportJobRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest.builder()
                .applyMutation(getBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain Data Integration Event. Developers can
     * view the eventType, eventGroupId, eventTimestamp, datasetTarget, datasetLoadExecution.
     * </p>
     *
     * @param getDataIntegrationEventRequest
     *        The request parameters for GetDataIntegrationEvent.
     * @return Result of the GetDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationEventResponse getDataIntegrationEvent(GetDataIntegrationEventRequest getDataIntegrationEventRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain Data Integration Event. Developers can
     * view the eventType, eventGroupId, eventTimestamp, datasetTarget, datasetLoadExecution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationEventRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataIntegrationEventRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventRequest.Builder} to create
     *        a request. The request parameters for GetDataIntegrationEvent.
     * @return Result of the GetDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationEventResponse getDataIntegrationEvent(
            Consumer<GetDataIntegrationEventRequest.Builder> getDataIntegrationEventRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getDataIntegrationEvent(GetDataIntegrationEventRequest.builder().applyMutation(getDataIntegrationEventRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically view a specific data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        The request parameters for GetDataIntegrationFlow.
     * @return Result of the GetDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowResponse getDataIntegrationFlow(GetDataIntegrationFlowRequest getDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view a specific data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationFlowRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest.Builder} to create
     *        a request. The request parameters for GetDataIntegrationFlow.
     * @return Result of the GetDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowResponse getDataIntegrationFlow(
            Consumer<GetDataIntegrationFlowRequest.Builder> getDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return getDataIntegrationFlow(GetDataIntegrationFlowRequest.builder().applyMutation(getDataIntegrationFlowRequest)
                .build());
    }

    /**
     * <p>
     * Get the flow execution.
     * </p>
     *
     * @param getDataIntegrationFlowExecutionRequest
     *        The request parameters of GetFlowExecution.
     * @return Result of the GetDataIntegrationFlowExecution operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowExecutionResponse getDataIntegrationFlowExecution(
            GetDataIntegrationFlowExecutionRequest getDataIntegrationFlowExecutionRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationFlowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataIntegrationFlowExecutionRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationFlowExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionRequest.Builder}
     *        to create a request. The request parameters of GetFlowExecution.
     * @return Result of the GetDataIntegrationFlowExecution operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataIntegrationFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationFlowExecutionResponse getDataIntegrationFlowExecution(
            Consumer<GetDataIntegrationFlowExecutionRequest.Builder> getDataIntegrationFlowExecutionRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getDataIntegrationFlowExecution(GetDataIntegrationFlowExecutionRequest.builder()
                .applyMutation(getDataIntegrationFlowExecutionRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake dataset. Developers can view
     * the data lake dataset information such as namespace, schema, and so on for a given instance ID, namespace, and
     * dataset name.
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        The request parameters for GetDataLakeDataset.
     * @return Result of the GetDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeDatasetResponse getDataLakeDataset(GetDataLakeDatasetRequest getDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake dataset. Developers can view
     * the data lake dataset information such as namespace, schema, and so on for a given instance ID, namespace, and
     * dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for GetDataLakeDataset.
     * @return Result of the GetDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeDatasetResponse getDataLakeDataset(Consumer<GetDataLakeDatasetRequest.Builder> getDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getDataLakeDataset(GetDataLakeDatasetRequest.builder().applyMutation(getDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake namespace. Developers can view
     * the data lake namespace information such as description for a given instance ID and namespace name.
     * </p>
     *
     * @param getDataLakeNamespaceRequest
     *        The request parameters for GetDataLakeNamespace.
     * @return Result of the GetDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeNamespaceResponse getDataLakeNamespace(GetDataLakeNamespaceRequest getDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake namespace. Developers can view
     * the data lake namespace information such as description for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeNamespaceRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param getDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceRequest.Builder} to create a
     *        request. The request parameters for GetDataLakeNamespace.
     * @return Result of the GetDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeNamespaceResponse getDataLakeNamespace(
            Consumer<GetDataLakeNamespaceRequest.Builder> getDataLakeNamespaceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return getDataLakeNamespace(GetDataLakeNamespaceRequest.builder().applyMutation(getDataLakeNamespaceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically retrieve the information related to an Amazon Web Services Supply Chain instance
     * ID.
     * </p>
     *
     * @param getInstanceRequest
     *        The request parameters for GetInstance.
     * @return Result of the GetInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically retrieve the information related to an Amazon Web Services Supply Chain instance
     * ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstanceRequest#builder()}
     * </p>
     *
     * @param getInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetInstanceRequest.Builder} to create a request.
     *        The request parameters for GetInstance.
     * @return Result of the GetInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.GetInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceResponse getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return getInstance(GetInstanceRequest.builder().applyMutation(getInstanceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically list all data integration events for the provided Amazon Web Services Supply
     * Chain instance.
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        The request parameters for ListDataIntegrationEvents.
     * @return Result of the ListDataIntegrationEvents operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsResponse listDataIntegrationEvents(
            ListDataIntegrationEventsRequest listDataIntegrationEventsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically list all data integration events for the provided Amazon Web Services Supply
     * Chain instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationEventsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationEvents.
     * @return Result of the ListDataIntegrationEvents operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsResponse listDataIntegrationEvents(
            Consumer<ListDataIntegrationEventsRequest.Builder> listDataIntegrationEventsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationEvents(ListDataIntegrationEventsRequest.builder()
                .applyMutation(listDataIntegrationEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client.listDataIntegrationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client
     *             .listDataIntegrationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client.listDataIntegrationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        The request parameters for ListDataIntegrationEvents.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsIterable listDataIntegrationEventsPaginator(
            ListDataIntegrationEventsRequest listDataIntegrationEventsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return new ListDataIntegrationEventsIterable(this, listDataIntegrationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client.listDataIntegrationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client
     *             .listDataIntegrationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsIterable responses = client.listDataIntegrationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationEventsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationEvents.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsIterable listDataIntegrationEventsPaginator(
            Consumer<ListDataIntegrationEventsRequest.Builder> listDataIntegrationEventsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationEventsPaginator(ListDataIntegrationEventsRequest.builder()
                .applyMutation(listDataIntegrationEventsRequest).build());
    }

    /**
     * <p>
     * List flow executions.
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        The request parameters of ListFlowExecutions.
     * @return Result of the ListDataIntegrationFlowExecutions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsResponse listDataIntegrationFlowExecutions(
            ListDataIntegrationFlowExecutionsRequest listDataIntegrationFlowExecutionsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List flow executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest.Builder}
     *        to create a request. The request parameters of ListFlowExecutions.
     * @return Result of the ListDataIntegrationFlowExecutions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsResponse listDataIntegrationFlowExecutions(
            Consumer<ListDataIntegrationFlowExecutionsRequest.Builder> listDataIntegrationFlowExecutionsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlowExecutions(ListDataIntegrationFlowExecutionsRequest.builder()
                .applyMutation(listDataIntegrationFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client.listDataIntegrationFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client
     *             .listDataIntegrationFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client.listDataIntegrationFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        The request parameters of ListFlowExecutions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsIterable listDataIntegrationFlowExecutionsPaginator(
            ListDataIntegrationFlowExecutionsRequest listDataIntegrationFlowExecutionsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return new ListDataIntegrationFlowExecutionsIterable(this, listDataIntegrationFlowExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client.listDataIntegrationFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client
     *             .listDataIntegrationFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsIterable responses = client.listDataIntegrationFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest.Builder}
     *        to create a request. The request parameters of ListFlowExecutions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsIterable listDataIntegrationFlowExecutionsPaginator(
            Consumer<ListDataIntegrationFlowExecutionsRequest.Builder> listDataIntegrationFlowExecutionsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlowExecutionsPaginator(ListDataIntegrationFlowExecutionsRequest.builder()
                .applyMutation(listDataIntegrationFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically list all data pipelines for the provided Amazon Web Services Supply Chain
     * instance.
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return Result of the ListDataIntegrationFlows operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsResponse listDataIntegrationFlows(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically list all data pipelines for the provided Amazon Web Services Supply Chain
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return Result of the ListDataIntegrationFlows operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsResponse listDataIntegrationFlows(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlows(ListDataIntegrationFlowsRequest.builder().applyMutation(listDataIntegrationFlowsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client
     *             .listDataIntegrationFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsIterable listDataIntegrationFlowsPaginator(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return new ListDataIntegrationFlowsIterable(this, listDataIntegrationFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client
     *             .listDataIntegrationFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsIterable responses = client.listDataIntegrationFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsIterable listDataIntegrationFlowsPaginator(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listDataIntegrationFlowsPaginator(ListDataIntegrationFlowsRequest.builder()
                .applyMutation(listDataIntegrationFlowsRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake datasets. Developers
     * can view the datasets and the corresponding information such as namespace, schema, and so on for a given instance
     * ID and namespace.
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return Result of the ListDataLakeDatasets operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsResponse listDataLakeDatasets(ListDataLakeDatasetsRequest listDataLakeDatasetsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake datasets. Developers
     * can view the datasets and the corresponding information such as namespace, schema, and so on for a given instance
     * ID and namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return Result of the ListDataLakeDatasets operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsResponse listDataLakeDatasets(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeDatasets(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client
     *             .listDataLakeDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsIterable listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest listDataLakeDatasetsRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return new ListDataLakeDatasetsIterable(this, listDataLakeDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client
     *             .listDataLakeDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsIterable responses = client.listDataLakeDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsIterable listDataLakeDatasetsPaginator(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake namespaces.
     * Developers can view the namespaces and the corresponding information such as description for a given instance ID.
     * Note that this API only return custom namespaces, instance pre-defined namespaces are not included.
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        The request parameters of ListDataLakeNamespaces.
     * @return Result of the ListDataLakeNamespaces operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesResponse listDataLakeNamespaces(ListDataLakeNamespacesRequest listDataLakeNamespacesRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake namespaces.
     * Developers can view the namespaces and the corresponding information such as description for a given instance ID.
     * Note that this API only return custom namespaces, instance pre-defined namespaces are not included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeNamespacesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeNamespacesRequest#builder()}
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest.Builder} to create
     *        a request. The request parameters of ListDataLakeNamespaces.
     * @return Result of the ListDataLakeNamespaces operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesResponse listDataLakeNamespaces(
            Consumer<ListDataLakeNamespacesRequest.Builder> listDataLakeNamespacesRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeNamespaces(ListDataLakeNamespacesRequest.builder().applyMutation(listDataLakeNamespacesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client.listDataLakeNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client
     *             .listDataLakeNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client.listDataLakeNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        The request parameters of ListDataLakeNamespaces.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesIterable listDataLakeNamespacesPaginator(
            ListDataLakeNamespacesRequest listDataLakeNamespacesRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return new ListDataLakeNamespacesIterable(this, listDataLakeNamespacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client.listDataLakeNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client
     *             .listDataLakeNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesIterable responses = client.listDataLakeNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeNamespacesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeNamespacesRequest#builder()}
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest.Builder} to create
     *        a request. The request parameters of ListDataLakeNamespaces.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesIterable listDataLakeNamespacesPaginator(
            Consumer<ListDataLakeNamespacesRequest.Builder> listDataLakeNamespacesRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listDataLakeNamespacesPaginator(ListDataLakeNamespacesRequest.builder()
                .applyMutation(listDataLakeNamespacesRequest).build());
    }

    /**
     * <p>
     * List all Amazon Web Services Supply Chain instances for a specific account. Enables you to programmatically list
     * all Amazon Web Services Supply Chain instances based on their account ID, instance name, and state of the
     * instance (active or delete).
     * </p>
     *
     * @param listInstancesRequest
     *        The request parameters for ListInstances.
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Amazon Web Services Supply Chain instances for a specific account. Enables you to programmatically list
     * all Amazon Web Services Supply Chain instances based on their account ID, instance name, and state of the
     * instance (active or delete).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListInstancesRequest.Builder} to create a
     *        request. The request parameters for ListInstances.
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client
     *             .listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     *        The request parameters for ListInstances.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return new ListInstancesIterable(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client
     *             .listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.supplychain.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListInstancesRequest.Builder} to create a
     *        request. The request parameters for ListInstances.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource. You can list all the tags added to a resource.
     * By listing the tags, developers can view the tag level information on a resource and perform actions such as,
     * deleting a resource associated with a particular tag.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request parameters of ListTagsForResource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource. You can list all the tags added to a resource.
     * By listing the tags, developers can view the tag level information on a resource and perform actions such as,
     * deleting a resource associated with a particular tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest.Builder} to create a
     *        request. The request parameters of ListTagsForResource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Send the data payload for the event with real-time data for analysis or monitoring. The real-time data events are
     * stored in an Amazon Web Services service before being processed and stored in data lake.
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        The request parameters for SendDataIntegrationEvent.
     * @return Result of the SendDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataIntegrationEventResponse sendDataIntegrationEvent(
            SendDataIntegrationEventRequest sendDataIntegrationEventRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send the data payload for the event with real-time data for analysis or monitoring. The real-time data events are
     * stored in an Amazon Web Services service before being processed and stored in data lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataIntegrationEventRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataIntegrationEventRequest#builder()}
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest.Builder} to
     *        create a request. The request parameters for SendDataIntegrationEvent.
     * @return Result of the SendDataIntegrationEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataIntegrationEventResponse sendDataIntegrationEvent(
            Consumer<SendDataIntegrationEventRequest.Builder> sendDataIntegrationEventRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return sendDataIntegrationEvent(SendDataIntegrationEventRequest.builder().applyMutation(sendDataIntegrationEventRequest)
                .build());
    }

    /**
     * <p>
     * You can create tags during or after creating a resource such as instance, data flow, or dataset in AWS Supply
     * chain. During the data ingestion process, you can add tags such as dev, test, or prod to data flows created
     * during the data ingestion process in the AWS Supply Chain datasets. You can use these tags to identify a group of
     * resources or a single resource used by the developer.
     * </p>
     *
     * @param tagResourceRequest
     *        The request parameters of TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can create tags during or after creating a resource such as instance, data flow, or dataset in AWS Supply
     * chain. During the data ingestion process, you can add tags such as dev, test, or prod to data flows created
     * during the data ingestion process in the AWS Supply Chain datasets. You can use these tags to identify a group of
     * resources or a single resource used by the developer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.TagResourceRequest.Builder} to create a request.
     *        The request parameters of TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * You can delete tags for an Amazon Web Services Supply chain resource such as instance, data flow, or dataset in
     * AWS Supply Chain. During the data ingestion process, you can delete tags such as dev, test, or prod to data flows
     * created during the data ingestion process in the AWS Supply Chain datasets.
     * </p>
     *
     * @param untagResourceRequest
     *        The request parameters of UntagResource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can delete tags for an Amazon Web Services Supply chain resource such as instance, data flow, or dataset in
     * AWS Supply Chain. During the data ingestion process, you can delete tags such as dev, test, or prod to data flows
     * created during the data ingestion process in the AWS Supply Chain datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UntagResourceRequest.Builder} to create a
     *        request. The request parameters of UntagResource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an existing data pipeline to ingest data from the source systems such as,
     * Amazon S3 buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a
     * temporary dataset along with the data transformation query provided with the API.
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        The request parameters for UpdateDataIntegrationFlow.
     * @return Result of the UpdateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationFlowResponse updateDataIntegrationFlow(
            UpdateDataIntegrationFlowRequest updateDataIntegrationFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an existing data pipeline to ingest data from the source systems such as,
     * Amazon S3 buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a
     * temporary dataset along with the data transformation query provided with the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for UpdateDataIntegrationFlow.
     * @return Result of the UpdateDataIntegrationFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationFlowResponse updateDataIntegrationFlow(
            Consumer<UpdateDataIntegrationFlowRequest.Builder> updateDataIntegrationFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return updateDataIntegrationFlow(UpdateDataIntegrationFlowRequest.builder()
                .applyMutation(updateDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake dataset. Developers can
     * update the description of a data lake dataset for a given instance ID, namespace, and dataset name.
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        The request parameters of UpdateDataLakeDataset.
     * @return Result of the UpdateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeDatasetResponse updateDataLakeDataset(UpdateDataLakeDatasetRequest updateDataLakeDatasetRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake dataset. Developers can
     * update the description of a data lake dataset for a given instance ID, namespace, and dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of UpdateDataLakeDataset.
     * @return Result of the UpdateDataLakeDataset operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeDatasetResponse updateDataLakeDataset(
            Consumer<UpdateDataLakeDatasetRequest.Builder> updateDataLakeDatasetRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, SupplyChainException {
        return updateDataLakeDataset(UpdateDataLakeDatasetRequest.builder().applyMutation(updateDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake namespace. Developers can
     * update the description of a data lake namespace for a given instance ID and namespace name.
     * </p>
     *
     * @param updateDataLakeNamespaceRequest
     *        The request parameters of UpdateDataLakeNamespace.
     * @return Result of the UpdateDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeNamespaceResponse updateDataLakeNamespace(UpdateDataLakeNamespaceRequest updateDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake namespace. Developers can
     * update the description of a data lake namespace for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param updateDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters of UpdateDataLakeNamespace.
     * @return Result of the UpdateDataLakeNamespace operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataLakeNamespaceResponse updateDataLakeNamespace(
            Consumer<UpdateDataLakeNamespaceRequest.Builder> updateDataLakeNamespaceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return updateDataLakeNamespace(UpdateDataLakeNamespaceRequest.builder().applyMutation(updateDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain instance description by providing all
     * the relevant information such as account ID, instance ID and so on without using the AWS console.
     * </p>
     *
     * @param updateInstanceRequest
     *        The request parameters for UpdateInstance.
     * @return Result of the UpdateInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInstanceResponse updateInstance(UpdateInstanceRequest updateInstanceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain instance description by providing all
     * the relevant information such as account ID, instance ID and so on without using the AWS console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInstanceRequest#builder()}
     * </p>
     *
     * @param updateInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateInstanceRequest.Builder} to create a
     *        request. The request parameters for UpdateInstance.
     * @return Result of the UpdateInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have the required privileges to perform this action.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupplyChainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupplyChainClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInstanceResponse updateInstance(Consumer<UpdateInstanceRequest.Builder> updateInstanceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            SupplyChainException {
        return updateInstance(UpdateInstanceRequest.builder().applyMutation(updateInstanceRequest).build());
    }

    /**
     * Create a {@link SupplyChainClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupplyChainClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupplyChainClient}.
     */
    static SupplyChainClientBuilder builder() {
        return new DefaultSupplyChainClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SupplyChainServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
