/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The BillOfMaterialsImportJob details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillOfMaterialsImportJob implements SdkPojo, Serializable,
        ToCopyableBuilder<BillOfMaterialsImportJob.Builder, BillOfMaterialsImportJob> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(BillOfMaterialsImportJob::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(BillOfMaterialsImportJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BillOfMaterialsImportJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3uri")
            .getter(getter(BillOfMaterialsImportJob::s3uri)).setter(setter(Builder::s3uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3uri").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BillOfMaterialsImportJob::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            JOB_ID_FIELD, STATUS_FIELD, S3_URI_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String jobId;

    private final String status;

    private final String s3uri;

    private final String message;

    private BillOfMaterialsImportJob(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.s3uri = builder.s3uri;
        this.message = builder.message;
    }

    /**
     * <p>
     * The BillOfMaterialsImportJob instanceId.
     * </p>
     * 
     * @return The BillOfMaterialsImportJob instanceId.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The BillOfMaterialsImportJob jobId.
     * </p>
     * 
     * @return The BillOfMaterialsImportJob jobId.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The BillOfMaterialsImportJob ConfigurationJobStatus.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The BillOfMaterialsImportJob ConfigurationJobStatus.
     * @see ConfigurationJobStatus
     */
    public final ConfigurationJobStatus status() {
        return ConfigurationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The BillOfMaterialsImportJob ConfigurationJobStatus.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The BillOfMaterialsImportJob ConfigurationJobStatus.
     * @see ConfigurationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The S3 URI from which the CSV is read.
     * </p>
     * 
     * @return The S3 URI from which the CSV is read.
     */
    public final String s3uri() {
        return s3uri;
    }

    /**
     * <p>
     * When the BillOfMaterialsImportJob has reached a terminal state, there will be a message.
     * </p>
     * 
     * @return When the BillOfMaterialsImportJob has reached a terminal state, there will be a message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3uri());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillOfMaterialsImportJob)) {
            return false;
        }
        BillOfMaterialsImportJob other = (BillOfMaterialsImportJob) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(s3uri(), other.s3uri())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillOfMaterialsImportJob").add("InstanceId", instanceId()).add("JobId", jobId())
                .add("Status", statusAsString()).add("S3uri", s3uri()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "s3uri":
            return Optional.ofNullable(clazz.cast(s3uri()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("s3uri", S3_URI_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillOfMaterialsImportJob, T> g) {
        return obj -> g.apply((BillOfMaterialsImportJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillOfMaterialsImportJob> {
        /**
         * <p>
         * The BillOfMaterialsImportJob instanceId.
         * </p>
         * 
         * @param instanceId
         *        The BillOfMaterialsImportJob instanceId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The BillOfMaterialsImportJob jobId.
         * </p>
         * 
         * @param jobId
         *        The BillOfMaterialsImportJob jobId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The BillOfMaterialsImportJob ConfigurationJobStatus.
         * </p>
         * 
         * @param status
         *        The BillOfMaterialsImportJob ConfigurationJobStatus.
         * @see ConfigurationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The BillOfMaterialsImportJob ConfigurationJobStatus.
         * </p>
         * 
         * @param status
         *        The BillOfMaterialsImportJob ConfigurationJobStatus.
         * @see ConfigurationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationJobStatus
         */
        Builder status(ConfigurationJobStatus status);

        /**
         * <p>
         * The S3 URI from which the CSV is read.
         * </p>
         * 
         * @param s3uri
         *        The S3 URI from which the CSV is read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3uri(String s3uri);

        /**
         * <p>
         * When the BillOfMaterialsImportJob has reached a terminal state, there will be a message.
         * </p>
         * 
         * @param message
         *        When the BillOfMaterialsImportJob has reached a terminal state, there will be a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String jobId;

        private String status;

        private String s3uri;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BillOfMaterialsImportJob model) {
            instanceId(model.instanceId);
            jobId(model.jobId);
            status(model.status);
            s3uri(model.s3uri);
            message(model.message);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getS3uri() {
            return s3uri;
        }

        public final void setS3uri(String s3uri) {
            this.s3uri = s3uri;
        }

        @Override
        public final Builder s3uri(String s3uri) {
            this.s3uri = s3uri;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BillOfMaterialsImportJob build() {
            return new BillOfMaterialsImportJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
