/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data integration event details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationEvent.Builder, DataIntegrationEvent> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(DataIntegrationEvent::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(DataIntegrationEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(DataIntegrationEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> EVENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventGroupId").getter(getter(DataIntegrationEvent::eventGroupId)).setter(setter(Builder::eventGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventGroupId").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp").getter(getter(DataIntegrationEvent::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<DataIntegrationEventDatasetTargetDetails> DATASET_TARGET_DETAILS_FIELD = SdkField
            .<DataIntegrationEventDatasetTargetDetails> builder(MarshallingType.SDK_POJO).memberName("datasetTargetDetails")
            .getter(getter(DataIntegrationEvent::datasetTargetDetails)).setter(setter(Builder::datasetTargetDetails))
            .constructor(DataIntegrationEventDatasetTargetDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTargetDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVENT_ID_FIELD, EVENT_TYPE_FIELD, EVENT_GROUP_ID_FIELD, EVENT_TIMESTAMP_FIELD, DATASET_TARGET_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String eventId;

    private final String eventType;

    private final String eventGroupId;

    private final Instant eventTimestamp;

    private final DataIntegrationEventDatasetTargetDetails datasetTargetDetails;

    private DataIntegrationEvent(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.eventGroupId = builder.eventGroupId;
        this.eventTimestamp = builder.eventTimestamp;
        this.datasetTargetDetails = builder.datasetTargetDetails;
    }

    /**
     * <p>
     * The AWS Supply Chain instance identifier.
     * </p>
     * 
     * @return The AWS Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique event identifier.
     * </p>
     * 
     * @return The unique event identifier.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The data event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The data event type.
     * @see DataIntegrationEventType
     */
    public final DataIntegrationEventType eventType() {
        return DataIntegrationEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The data event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The data event type.
     * @see DataIntegrationEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * Event identifier (for example, orderId for InboundOrder) used for data sharding or partitioning.
     * </p>
     * 
     * @return Event identifier (for example, orderId for InboundOrder) used for data sharding or partitioning.
     */
    public final String eventGroupId() {
        return eventGroupId;
    }

    /**
     * <p>
     * The event timestamp (in epoch seconds).
     * </p>
     * 
     * @return The event timestamp (in epoch seconds).
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The target dataset details for a DATASET event type.
     * </p>
     * 
     * @return The target dataset details for a DATASET event type.
     */
    public final DataIntegrationEventDatasetTargetDetails datasetTargetDetails() {
        return datasetTargetDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTargetDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEvent)) {
            return false;
        }
        DataIntegrationEvent other = (DataIntegrationEvent) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(eventGroupId(), other.eventGroupId())
                && Objects.equals(eventTimestamp(), other.eventTimestamp())
                && Objects.equals(datasetTargetDetails(), other.datasetTargetDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationEvent").add("InstanceId", instanceId()).add("EventId", eventId())
                .add("EventType", eventTypeAsString()).add("EventGroupId", eventGroupId())
                .add("EventTimestamp", eventTimestamp()).add("DatasetTargetDetails", datasetTargetDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "eventGroupId":
            return Optional.ofNullable(clazz.cast(eventGroupId()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "datasetTargetDetails":
            return Optional.ofNullable(clazz.cast(datasetTargetDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventGroupId", EVENT_GROUP_ID_FIELD);
        map.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("datasetTargetDetails", DATASET_TARGET_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEvent, T> g) {
        return obj -> g.apply((DataIntegrationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationEvent> {
        /**
         * <p>
         * The AWS Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The AWS Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique event identifier.
         * </p>
         * 
         * @param eventId
         *        The unique event identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The data event type.
         * </p>
         * 
         * @param eventType
         *        The data event type.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The data event type.
         * </p>
         * 
         * @param eventType
         *        The data event type.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(DataIntegrationEventType eventType);

        /**
         * <p>
         * Event identifier (for example, orderId for InboundOrder) used for data sharding or partitioning.
         * </p>
         * 
         * @param eventGroupId
         *        Event identifier (for example, orderId for InboundOrder) used for data sharding or partitioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventGroupId(String eventGroupId);

        /**
         * <p>
         * The event timestamp (in epoch seconds).
         * </p>
         * 
         * @param eventTimestamp
         *        The event timestamp (in epoch seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The target dataset details for a DATASET event type.
         * </p>
         * 
         * @param datasetTargetDetails
         *        The target dataset details for a DATASET event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTargetDetails(DataIntegrationEventDatasetTargetDetails datasetTargetDetails);

        /**
         * <p>
         * The target dataset details for a DATASET event type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationEventDatasetTargetDetails.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationEventDatasetTargetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationEventDatasetTargetDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #datasetTargetDetails(DataIntegrationEventDatasetTargetDetails)}.
         * 
         * @param datasetTargetDetails
         *        a consumer that will call methods on {@link DataIntegrationEventDatasetTargetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetTargetDetails(DataIntegrationEventDatasetTargetDetails)
         */
        default Builder datasetTargetDetails(Consumer<DataIntegrationEventDatasetTargetDetails.Builder> datasetTargetDetails) {
            return datasetTargetDetails(DataIntegrationEventDatasetTargetDetails.builder().applyMutation(datasetTargetDetails)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String eventId;

        private String eventType;

        private String eventGroupId;

        private Instant eventTimestamp;

        private DataIntegrationEventDatasetTargetDetails datasetTargetDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEvent model) {
            instanceId(model.instanceId);
            eventId(model.eventId);
            eventType(model.eventType);
            eventGroupId(model.eventGroupId);
            eventTimestamp(model.eventTimestamp);
            datasetTargetDetails(model.datasetTargetDetails);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DataIntegrationEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getEventGroupId() {
            return eventGroupId;
        }

        public final void setEventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
        }

        @Override
        public final Builder eventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final DataIntegrationEventDatasetTargetDetails.Builder getDatasetTargetDetails() {
            return datasetTargetDetails != null ? datasetTargetDetails.toBuilder() : null;
        }

        public final void setDatasetTargetDetails(DataIntegrationEventDatasetTargetDetails.BuilderImpl datasetTargetDetails) {
            this.datasetTargetDetails = datasetTargetDetails != null ? datasetTargetDetails.build() : null;
        }

        @Override
        public final Builder datasetTargetDetails(DataIntegrationEventDatasetTargetDetails datasetTargetDetails) {
            this.datasetTargetDetails = datasetTargetDetails;
            return this;
        }

        @Override
        public DataIntegrationEvent build() {
            return new DataIntegrationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
