/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target dataset configuration for a DATASET event type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationEventDatasetTargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationEventDatasetTargetConfiguration.Builder, DataIntegrationEventDatasetTargetConfiguration> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetIdentifier").getter(getter(DataIntegrationEventDatasetTargetConfiguration::datasetIdentifier))
            .setter(setter(Builder::datasetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(DataIntegrationEventDatasetTargetConfiguration::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD,
            OPERATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetIdentifier;

    private final String operationType;

    private DataIntegrationEventDatasetTargetConfiguration(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
        this.operationType = builder.operationType;
    }

    /**
     * <p>
     * The datalake dataset ARN identifier.
     * </p>
     * 
     * @return The datalake dataset ARN identifier.
     */
    public final String datasetIdentifier() {
        return datasetIdentifier;
    }

    /**
     * <p>
     * The target dataset load operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link DataIntegrationEventDatasetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The target dataset load operation type.
     * @see DataIntegrationEventDatasetOperationType
     */
    public final DataIntegrationEventDatasetOperationType operationType() {
        return DataIntegrationEventDatasetOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The target dataset load operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link DataIntegrationEventDatasetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The target dataset load operation type.
     * @see DataIntegrationEventDatasetOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEventDatasetTargetConfiguration)) {
            return false;
        }
        DataIntegrationEventDatasetTargetConfiguration other = (DataIntegrationEventDatasetTargetConfiguration) obj;
        return Objects.equals(datasetIdentifier(), other.datasetIdentifier())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationEventDatasetTargetConfiguration").add("DatasetIdentifier", datasetIdentifier())
                .add("OperationType", operationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetIdentifier":
            return Optional.ofNullable(clazz.cast(datasetIdentifier()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEventDatasetTargetConfiguration, T> g) {
        return obj -> g.apply((DataIntegrationEventDatasetTargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationEventDatasetTargetConfiguration> {
        /**
         * <p>
         * The datalake dataset ARN identifier.
         * </p>
         * 
         * @param datasetIdentifier
         *        The datalake dataset ARN identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetIdentifier(String datasetIdentifier);

        /**
         * <p>
         * The target dataset load operation type.
         * </p>
         * 
         * @param operationType
         *        The target dataset load operation type.
         * @see DataIntegrationEventDatasetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventDatasetOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The target dataset load operation type.
         * </p>
         * 
         * @param operationType
         *        The target dataset load operation type.
         * @see DataIntegrationEventDatasetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventDatasetOperationType
         */
        Builder operationType(DataIntegrationEventDatasetOperationType operationType);
    }

    static final class BuilderImpl implements Builder {
        private String datasetIdentifier;

        private String operationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEventDatasetTargetConfiguration model) {
            datasetIdentifier(model.datasetIdentifier);
            operationType(model.operationType);
        }

        public final String getDatasetIdentifier() {
            return datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(DataIntegrationEventDatasetOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        @Override
        public DataIntegrationEventDatasetTargetConfiguration build() {
            return new DataIntegrationEventDatasetTargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
