/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deduplication strategy details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowDedupeStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowDedupeStrategy.Builder, DataIntegrationFlowDedupeStrategy> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataIntegrationFlowDedupeStrategy::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration> FIELD_PRIORITY_FIELD = SdkField
            .<DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("fieldPriority").getter(getter(DataIntegrationFlowDedupeStrategy::fieldPriority))
            .setter(setter(Builder::fieldPriority))
            .constructor(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldPriority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            FIELD_PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration fieldPriority;

    private DataIntegrationFlowDedupeStrategy(BuilderImpl builder) {
        this.type = builder.type;
        this.fieldPriority = builder.fieldPriority;
    }

    /**
     * <p>
     * The type of the deduplication strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered list of
     * fields used to tie-break the data records sharing the same primary key values. Fields earlier in the list have
     * higher priority for evaluation. For each field, the sort order determines whether to retain data record with
     * larger or smaller field value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataIntegrationFlowDedupeStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the deduplication strategy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered
     *         list of fields used to tie-break the data records sharing the same primary key values. Fields earlier in
     *         the list have higher priority for evaluation. For each field, the sort order determines whether to retain
     *         data record with larger or smaller field value.
     *         </p>
     *         </li>
     * @see DataIntegrationFlowDedupeStrategyType
     */
    public final DataIntegrationFlowDedupeStrategyType type() {
        return DataIntegrationFlowDedupeStrategyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the deduplication strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered list of
     * fields used to tie-break the data records sharing the same primary key values. Fields earlier in the list have
     * higher priority for evaluation. For each field, the sort order determines whether to retain data record with
     * larger or smaller field value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataIntegrationFlowDedupeStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the deduplication strategy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered
     *         list of fields used to tie-break the data records sharing the same primary key values. Fields earlier in
     *         the list have higher priority for evaluation. For each field, the sort order determines whether to retain
     *         data record with larger or smaller field value.
     *         </p>
     *         </li>
     * @see DataIntegrationFlowDedupeStrategyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The field priority deduplication strategy.
     * </p>
     * 
     * @return The field priority deduplication strategy.
     */
    public final DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration fieldPriority() {
        return fieldPriority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldPriority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDedupeStrategy)) {
            return false;
        }
        DataIntegrationFlowDedupeStrategy other = (DataIntegrationFlowDedupeStrategy) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(fieldPriority(), other.fieldPriority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowDedupeStrategy").add("Type", typeAsString())
                .add("FieldPriority", fieldPriority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "fieldPriority":
            return Optional.ofNullable(clazz.cast(fieldPriority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("fieldPriority", FIELD_PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDedupeStrategy, T> g) {
        return obj -> g.apply((DataIntegrationFlowDedupeStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowDedupeStrategy> {
        /**
         * <p>
         * The type of the deduplication strategy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered list
         * of fields used to tie-break the data records sharing the same primary key values. Fields earlier in the list
         * have higher priority for evaluation. For each field, the sort order determines whether to retain data record
         * with larger or smaller field value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the deduplication strategy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an
         *        ordered list of fields used to tie-break the data records sharing the same primary key values. Fields
         *        earlier in the list have higher priority for evaluation. For each field, the sort order determines
         *        whether to retain data record with larger or smaller field value.
         *        </p>
         *        </li>
         * @see DataIntegrationFlowDedupeStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowDedupeStrategyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the deduplication strategy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an ordered list
         * of fields used to tie-break the data records sharing the same primary key values. Fields earlier in the list
         * have higher priority for evaluation. For each field, the sort order determines whether to retain data record
         * with larger or smaller field value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the deduplication strategy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FIELD_PRIORITY</b> - Field priority configuration for the deduplication strategy specifies an
         *        ordered list of fields used to tie-break the data records sharing the same primary key values. Fields
         *        earlier in the list have higher priority for evaluation. For each field, the sort order determines
         *        whether to retain data record with larger or smaller field value.
         *        </p>
         *        </li>
         * @see DataIntegrationFlowDedupeStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowDedupeStrategyType
         */
        Builder type(DataIntegrationFlowDedupeStrategyType type);

        /**
         * <p>
         * The field priority deduplication strategy.
         * </p>
         * 
         * @param fieldPriority
         *        The field priority deduplication strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration fieldPriority);

        /**
         * <p>
         * The field priority deduplication strategy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.Builder} avoiding the need to create one
         * manually via {@link DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration)}.
         * 
         * @param fieldPriority
         *        a consumer that will call methods on
         *        {@link DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration)
         */
        default Builder fieldPriority(Consumer<DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.Builder> fieldPriority) {
            return fieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.builder()
                    .applyMutation(fieldPriority).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration fieldPriority;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDedupeStrategy model) {
            type(model.type);
            fieldPriority(model.fieldPriority);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataIntegrationFlowDedupeStrategyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.Builder getFieldPriority() {
            return fieldPriority != null ? fieldPriority.toBuilder() : null;
        }

        public final void setFieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration.BuilderImpl fieldPriority) {
            this.fieldPriority = fieldPriority != null ? fieldPriority.build() : null;
        }

        @Override
        public final Builder fieldPriority(DataIntegrationFlowFieldPriorityDedupeStrategyConfiguration fieldPriority) {
            this.fieldPriority = fieldPriority;
            return this;
        }

        @Override
        public DataIntegrationFlowDedupeStrategy build() {
            return new DataIntegrationFlowDedupeStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
