/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 options used in S3 source and target configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowS3Options implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowS3Options.Builder, DataIntegrationFlowS3Options> {
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(DataIntegrationFlowS3Options::fileTypeAsString))
            .setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileType;

    private DataIntegrationFlowS3Options(BuilderImpl builder) {
        this.fileType = builder.fileType;
    }

    /**
     * <p>
     * The Amazon S3 file type in S3 options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link DataIntegrationFlowFileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The Amazon S3 file type in S3 options.
     * @see DataIntegrationFlowFileType
     */
    public final DataIntegrationFlowFileType fileType() {
        return DataIntegrationFlowFileType.fromValue(fileType);
    }

    /**
     * <p>
     * The Amazon S3 file type in S3 options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link DataIntegrationFlowFileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The Amazon S3 file type in S3 options.
     * @see DataIntegrationFlowFileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowS3Options)) {
            return false;
        }
        DataIntegrationFlowS3Options other = (DataIntegrationFlowS3Options) obj;
        return Objects.equals(fileTypeAsString(), other.fileTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowS3Options").add("FileType", fileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileType", FILE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowS3Options, T> g) {
        return obj -> g.apply((DataIntegrationFlowS3Options) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowS3Options> {
        /**
         * <p>
         * The Amazon S3 file type in S3 options.
         * </p>
         * 
         * @param fileType
         *        The Amazon S3 file type in S3 options.
         * @see DataIntegrationFlowFileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowFileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * The Amazon S3 file type in S3 options.
         * </p>
         * 
         * @param fileType
         *        The Amazon S3 file type in S3 options.
         * @see DataIntegrationFlowFileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowFileType
         */
        Builder fileType(DataIntegrationFlowFileType fileType);
    }

    static final class BuilderImpl implements Builder {
        private String fileType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowS3Options model) {
            fileType(model.fileType);
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(DataIntegrationFlowFileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        @Override
        public DataIntegrationFlowS3Options build() {
            return new DataIntegrationFlowS3Options(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
