/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 DataIntegrationFlow source configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowS3SourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowS3SourceConfiguration.Builder, DataIntegrationFlowS3SourceConfiguration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(DataIntegrationFlowS3SourceConfiguration::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(DataIntegrationFlowS3SourceConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<DataIntegrationFlowS3Options> OPTIONS_FIELD = SdkField
            .<DataIntegrationFlowS3Options> builder(MarshallingType.SDK_POJO).memberName("options")
            .getter(getter(DataIntegrationFlowS3SourceConfiguration::options)).setter(setter(Builder::options))
            .constructor(DataIntegrationFlowS3Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            PREFIX_FIELD, OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String prefix;

    private final DataIntegrationFlowS3Options options;

    private DataIntegrationFlowS3SourceConfiguration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.options = builder.options;
    }

    /**
     * <p>
     * The bucketName of the S3 source objects.
     * </p>
     * 
     * @return The bucketName of the S3 source objects.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix of the S3 source objects. To trigger data ingestion, S3 files need to be put under
     * <code>s3://<i>bucketName</i>/<i>prefix</i>/</code>.
     * </p>
     * 
     * @return The prefix of the S3 source objects. To trigger data ingestion, S3 files need to be put under
     *         <code>s3://<i>bucketName</i>/<i>prefix</i>/</code>.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The other options of the S3 DataIntegrationFlow source.
     * </p>
     * 
     * @return The other options of the S3 DataIntegrationFlow source.
     */
    public final DataIntegrationFlowS3Options options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowS3SourceConfiguration)) {
            return false;
        }
        DataIntegrationFlowS3SourceConfiguration other = (DataIntegrationFlowS3SourceConfiguration) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowS3SourceConfiguration").add("BucketName", bucketName())
                .add("Prefix", prefix()).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowS3SourceConfiguration, T> g) {
        return obj -> g.apply((DataIntegrationFlowS3SourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowS3SourceConfiguration> {
        /**
         * <p>
         * The bucketName of the S3 source objects.
         * </p>
         * 
         * @param bucketName
         *        The bucketName of the S3 source objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix of the S3 source objects. To trigger data ingestion, S3 files need to be put under
         * <code>s3://<i>bucketName</i>/<i>prefix</i>/</code>.
         * </p>
         * 
         * @param prefix
         *        The prefix of the S3 source objects. To trigger data ingestion, S3 files need to be put under
         *        <code>s3://<i>bucketName</i>/<i>prefix</i>/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The other options of the S3 DataIntegrationFlow source.
         * </p>
         * 
         * @param options
         *        The other options of the S3 DataIntegrationFlow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(DataIntegrationFlowS3Options options);

        /**
         * <p>
         * The other options of the S3 DataIntegrationFlow source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationFlowS3Options.Builder}
         * avoiding the need to create one manually via {@link DataIntegrationFlowS3Options#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowS3Options.Builder#build()} is called
         * immediately and its result is passed to {@link #options(DataIntegrationFlowS3Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link DataIntegrationFlowS3Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(DataIntegrationFlowS3Options)
         */
        default Builder options(Consumer<DataIntegrationFlowS3Options.Builder> options) {
            return options(DataIntegrationFlowS3Options.builder().applyMutation(options).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String prefix;

        private DataIntegrationFlowS3Options options;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowS3SourceConfiguration model) {
            bucketName(model.bucketName);
            prefix(model.prefix);
            options(model.options);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final DataIntegrationFlowS3Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(DataIntegrationFlowS3Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(DataIntegrationFlowS3Options options) {
            this.options = options;
            return this;
        }

        @Override
        public DataIntegrationFlowS3SourceConfiguration build() {
            return new DataIntegrationFlowS3SourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
